/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v21.segment;

// import ca.uhn.hl7v2.model.v21.group.*;
import ca.uhn.hl7v2.model.v21.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 URS message segment (UNSOLICITED SELECTION). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>URS-1: R/U WHERE SUBJECT DEFINITION (ST) <b> repeating</b>
     * <li>URS-2: R/U WHEN DATA START DATE/TIME (TS) <b>optional </b>
     * <li>URS-3: R/U WHEN DATA END DATE/TIME (TS) <b>optional </b>
     * <li>URS-4: R/U WHAT USER QUALIFIER (ST) <b>optional repeating</b>
     * <li>URS-5: R/U OTHER RESULTS SUBJECT DEFINI (ST) <b>optional repeating</b>
 * </ul>
 */
public class URS extends AbstractSegment {

    /** 
     * Creates a new URS segment
     */
    public URS(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(ST.class, true, 0, 20, new Object[]{ getMessage(), new Integer(0) }, "R/U WHERE SUBJECT DEFINITION");
                                  this.add(TS.class, false, 1, 19, new Object[]{ getMessage(), new Integer(0) }, "R/U WHEN DATA START DATE/TIME");
                                  this.add(TS.class, false, 1, 19, new Object[]{ getMessage(), new Integer(0) }, "R/U WHEN DATA END DATE/TIME");
                                  this.add(ST.class, false, 0, 20, new Object[]{ getMessage(), new Integer(0) }, "R/U WHAT USER QUALIFIER");
                                  this.add(ST.class, false, 0, 20, new Object[]{ getMessage(), new Integer(0) }, "R/U OTHER RESULTS SUBJECT DEFINI");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating URS - this is probably a bug in the source code generator.", e);
       }
    }


    /**
     * Returns all repetitions of R/U WHERE SUBJECT DEFINITION (URS-1).
     */
    public ST[] getRUWHERESUBJECTDEFINITION() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(1);  
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ST)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * URS-1: "R/U WHERE SUBJECT DEFINITION" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getRUWHERESUBJECTDEFINITION(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * URS-1: "R/U WHERE SUBJECT DEFINITION" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getUrs1_RUWHERESUBJECTDEFINITION(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * URS-1: "R/U WHERE SUBJECT DEFINITION" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertRUWHERESUBJECTDEFINITION(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(1, rep);
    }



    /**
     * Inserts a repetition of
     * URS-1: "R/U WHERE SUBJECT DEFINITION" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertUrs1_RUWHERESUBJECTDEFINITION(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * URS-1: "R/U WHERE SUBJECT DEFINITION" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeRUWHERESUBJECTDEFINITION(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * URS-1: "R/U WHERE SUBJECT DEFINITION" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeUrs1_RUWHERESUBJECTDEFINITION(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(1, rep);
    }




    /**
     * Returns
     * URS-2: "R/U WHEN DATA START DATE/TIME" - creates it if necessary
     */
    public TS getRUWHENDATASTARTDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * URS-2: "R/U WHEN DATA START DATE/TIME" - creates it if necessary
     */
    public TS getUrs2_RUWHENDATASTARTDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * URS-3: "R/U WHEN DATA END DATE/TIME" - creates it if necessary
     */
    public TS getRUWHENDATAENDDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * URS-3: "R/U WHEN DATA END DATE/TIME" - creates it if necessary
     */
    public TS getUrs3_RUWHENDATAENDDATETIME() { 
        TS ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of R/U WHAT USER QUALIFIER (URS-4).
     */
    public ST[] getRUWHATUSERQUALIFIER() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(4);  
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ST)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * URS-4: "R/U WHAT USER QUALIFIER" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getRUWHATUSERQUALIFIER(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * URS-4: "R/U WHAT USER QUALIFIER" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getUrs4_RUWHATUSERQUALIFIER(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * URS-4: "R/U WHAT USER QUALIFIER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertRUWHATUSERQUALIFIER(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(4, rep);
    }



    /**
     * Inserts a repetition of
     * URS-4: "R/U WHAT USER QUALIFIER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertUrs4_RUWHATUSERQUALIFIER(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * URS-4: "R/U WHAT USER QUALIFIER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeRUWHATUSERQUALIFIER(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * URS-4: "R/U WHAT USER QUALIFIER" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeUrs4_RUWHATUSERQUALIFIER(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(4, rep);
    }



    /**
     * Returns all repetitions of R/U OTHER RESULTS SUBJECT DEFINI (URS-5).
     */
    public ST[] getRUOTHERRESULTSSUBJECTDEFINI() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(5);  
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ST)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * URS-5: "R/U OTHER RESULTS SUBJECT DEFINI" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getRUOTHERRESULTSSUBJECTDEFINI(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * URS-5: "R/U OTHER RESULTS SUBJECT DEFINI" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getUrs5_RUOTHERRESULTSSUBJECTDEFINI(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * URS-5: "R/U OTHER RESULTS SUBJECT DEFINI" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertRUOTHERRESULTSSUBJECTDEFINI(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(5, rep);
    }



    /**
     * Inserts a repetition of
     * URS-5: "R/U OTHER RESULTS SUBJECT DEFINI" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertUrs5_RUOTHERRESULTSSUBJECTDEFINI(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * URS-5: "R/U OTHER RESULTS SUBJECT DEFINI" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeRUOTHERRESULTSSUBJECTDEFINI(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * URS-5: "R/U OTHER RESULTS SUBJECT DEFINI" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeUrs5_RUOTHERRESULTSSUBJECTDEFINI(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(5, rep);
    }






    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new ST(getMessage());
          case 1: return new TS(getMessage());
          case 2: return new TS(getMessage());
          case 3: return new ST(getMessage());
          case 4: return new ST(getMessage());
          default: return null;
       }
   }


}

