/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CM_NDL (observing practitioner) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>interpreter / technician (CN)
 * <li>start date/time (TS)
 * <li>end date/time (TS)
 * <li>location (CM_INTERNAL_LOCATION)
 * </ul>
 */
public class CM_NDL extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CM_NDL type
     */
    public CM_NDL(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[4];    
        data[0] = new CN(getMessage());
        data[1] = new TS(getMessage());
        data[2] = new TS(getMessage());
        data[3] = new CM_INTERNAL_LOCATION(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns interpreter / technician (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CN getInterpreterTechnician() {
       CN ret = null;
       try {
          ret = (CN)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns interpreter / technician (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CN getCm_ndl1_InterpreterTechnician() {
       CN ret = null;
       try {
          ret = (CN)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns start date/time (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getStartDateTime() {
       TS ret = null;
       try {
          ret = (TS)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns start date/time (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getCm_ndl2_StartDateTime() {
       TS ret = null;
       try {
          ret = (TS)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns end date/time (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getEndDateTime() {
       TS ret = null;
       try {
          ret = (TS)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns end date/time (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getCm_ndl3_EndDateTime() {
       TS ret = null;
       try {
          ret = (TS)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns location (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_INTERNAL_LOCATION getLocation() {
       CM_INTERNAL_LOCATION ret = null;
       try {
          ret = (CM_INTERNAL_LOCATION)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns location (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_INTERNAL_LOCATION getCm_ndl4_Location() {
       CM_INTERNAL_LOCATION ret = null;
       try {
          ret = (CM_INTERNAL_LOCATION)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

