/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 TQ (timing quantity) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Quantity (CQ_QUANTITY)
 * <li>interval (CM_RI)
 * <li>duration (ST)
 * <li>start date/time (TS)
 * <li>end date/time (TS)
 * <li>priority (ID)
 * <li>condition (ST)
 * <li>text (TX) (TX)
 * <li>conjunction (ID)
 * <li>order sequencing (ST)
 * </ul>
 */
public class TQ extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new TQ type
     */
    public TQ(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[10];    
        data[0] = new CQ_QUANTITY(getMessage());
        data[1] = new CM_RI(getMessage());
        data[2] = new ST(getMessage());
        data[3] = new TS(getMessage());
        data[4] = new TS(getMessage());
        data[5] = new ID(getMessage(), 0);
        data[6] = new ST(getMessage());
        data[7] = new TX(getMessage());
        data[8] = new ID(getMessage(), 0);
        data[9] = new ST(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Quantity (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CQ_QUANTITY getQuantity() {
       CQ_QUANTITY ret = null;
       try {
          ret = (CQ_QUANTITY)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Quantity (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CQ_QUANTITY getTq1_Quantity() {
       CQ_QUANTITY ret = null;
       try {
          ret = (CQ_QUANTITY)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns interval (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_RI getInterval() {
       CM_RI ret = null;
       try {
          ret = (CM_RI)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns interval (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CM_RI getTq2_Interval() {
       CM_RI ret = null;
       try {
          ret = (CM_RI)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns duration (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getDuration() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns duration (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getTq3_Duration() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns start date/time (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getStartDateTime() {
       TS ret = null;
       try {
          ret = (TS)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns start date/time (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getTq4_StartDateTime() {
       TS ret = null;
       try {
          ret = (TS)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns end date/time (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getEndDateTime() {
       TS ret = null;
       try {
          ret = (TS)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns end date/time (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getTq5_EndDateTime() {
       TS ret = null;
       try {
          ret = (TS)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns priority (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getPriority() {
       ID ret = null;
       try {
          ret = (ID)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns priority (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getTq6_Priority() {
       ID ret = null;
       try {
          ret = (ID)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns condition (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCondition() {
       ST ret = null;
       try {
          ret = (ST)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns condition (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getTq7_Condition() {
       ST ret = null;
       try {
          ret = (ST)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns text (TX) (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getText() {
       TX ret = null;
       try {
          ret = (TX)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns text (TX) (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getTq8_Text() {
       TX ret = null;
       try {
          ret = (TX)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns conjunction (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getConjunction() {
       ID ret = null;
       try {
          ret = (ID)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns conjunction (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getTq9_Conjunction() {
       ID ret = null;
       try {
          ret = (ID)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns order sequencing (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getOrderSequencing() {
       ST ret = null;
       try {
          ret = (ST)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns order sequencing (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getTq10_OrderSequencing() {
       ST ret = null;
       try {
          ret = (ST)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

