/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.segment;

// import ca.uhn.hl7v2.model.v22.group.*;
import ca.uhn.hl7v2.model.v22.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 PR1 message segment (PROCEDURES). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>PR1-1: Set ID - procedure (SI) <b> </b>
     * <li>PR1-2: Procedure coding method (ID) <b> repeating</b>
     * <li>PR1-3: Procedure code (ID) <b> repeating</b>
     * <li>PR1-4: Procedure description (ST) <b>optional repeating</b>
     * <li>PR1-5: Procedure date / time (TS) <b> </b>
     * <li>PR1-6: Procedure type (ID) <b> </b>
     * <li>PR1-7: Procedure minutes (NM) <b>optional </b>
     * <li>PR1-8: Anesthesiologist (CN) <b>optional </b>
     * <li>PR1-9: Anesthesia code (ID) <b>optional </b>
     * <li>PR1-10: Anesthesia minutes (NM) <b>optional </b>
     * <li>PR1-11: Surgeon (CN) <b>optional </b>
     * <li>PR1-12: Procedure Practitioner (CM_PRACTITIONER) <b>optional repeating</b>
     * <li>PR1-13: Consent code (ID) <b>optional </b>
     * <li>PR1-14: Procedure priority (NM) <b>optional </b>
 * </ul>
 */
public class PR1 extends AbstractSegment {

    /** 
     * Creates a new PR1 segment
     */
    public PR1(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Set ID - procedure");
                                  this.add(ID.class, true, 0, 2, new Object[]{ getMessage() }, "Procedure coding method");
                                  this.add(ID.class, true, 0, 10, new Object[]{ getMessage() }, "Procedure code");
                                  this.add(ST.class, false, 0, 40, new Object[]{ getMessage(), new Integer(0) }, "Procedure description");
                                  this.add(TS.class, true, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Procedure date / time");
                                  this.add(ID.class, true, 1, 2, new Object[]{ getMessage() }, "Procedure type");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Procedure minutes");
                                  this.add(CN.class, false, 1, 60, new Object[]{ getMessage(), new Integer(10) }, "Anesthesiologist");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "Anesthesia code");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Anesthesia minutes");
                                  this.add(CN.class, false, 1, 60, new Object[]{ getMessage(), new Integer(10) }, "Surgeon");
                                  this.add(CM_PRACTITIONER.class, false, 0, 60, new Object[]{ getMessage(), new Integer(10) }, "Procedure Practitioner");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "Consent code");
                                  this.add(NM.class, false, 1, 2, new Object[]{ getMessage(), new Integer(0) }, "Procedure priority");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PR1 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * PR1-1: "Set ID - procedure" - creates it if necessary
     */
    public SI getSetIDProcedure() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-1: "Set ID - procedure" - creates it if necessary
     */
    public SI getPr11_SetIDProcedure() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Procedure coding method (PR1-2).
     */
    public ID[] getProcedureCodingMethod() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(2);  
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ID)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PR1-2: "Procedure coding method" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getProcedureCodingMethod(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PR1-2: "Procedure coding method" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getPr12_ProcedureCodingMethod(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PR1-2: "Procedure coding method" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertProcedureCodingMethod(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(2, rep);
    }



    /**
     * Inserts a repetition of
     * PR1-2: "Procedure coding method" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertPr12_ProcedureCodingMethod(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * PR1-2: "Procedure coding method" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeProcedureCodingMethod(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * PR1-2: "Procedure coding method" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removePr12_ProcedureCodingMethod(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(2, rep);
    }



    /**
     * Returns all repetitions of Procedure code (PR1-3).
     */
    public ID[] getProcedureCode() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(3);  
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ID)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PR1-3: "Procedure code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getProcedureCode(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PR1-3: "Procedure code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getPr13_ProcedureCode(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PR1-3: "Procedure code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertProcedureCode(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(3, rep);
    }



    /**
     * Inserts a repetition of
     * PR1-3: "Procedure code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertPr13_ProcedureCode(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * PR1-3: "Procedure code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeProcedureCode(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * PR1-3: "Procedure code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removePr13_ProcedureCode(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(3, rep);
    }



    /**
     * Returns all repetitions of Procedure description (PR1-4).
     */
    public ST[] getProcedureDescription() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(4);  
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ST)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PR1-4: "Procedure description" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getProcedureDescription(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PR1-4: "Procedure description" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getPr14_ProcedureDescription(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PR1-4: "Procedure description" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertProcedureDescription(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(4, rep);
    }



    /**
     * Inserts a repetition of
     * PR1-4: "Procedure description" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertPr14_ProcedureDescription(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * PR1-4: "Procedure description" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeProcedureDescription(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * PR1-4: "Procedure description" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removePr14_ProcedureDescription(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(4, rep);
    }




    /**
     * Returns
     * PR1-5: "Procedure date / time" - creates it if necessary
     */
    public TS getProcedureDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-5: "Procedure date / time" - creates it if necessary
     */
    public TS getPr15_ProcedureDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-6: "Procedure type" - creates it if necessary
     */
    public ID getProcedureType() { 
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-6: "Procedure type" - creates it if necessary
     */
    public ID getPr16_ProcedureType() { 
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-7: "Procedure minutes" - creates it if necessary
     */
    public NM getProcedureMinutes() { 
        NM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-7: "Procedure minutes" - creates it if necessary
     */
    public NM getPr17_ProcedureMinutes() { 
        NM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-8: "Anesthesiologist" - creates it if necessary
     */
    public CN getAnesthesiologist() { 
        CN ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-8: "Anesthesiologist" - creates it if necessary
     */
    public CN getPr18_Anesthesiologist() { 
        CN ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-9: "Anesthesia code" - creates it if necessary
     */
    public ID getAnesthesiaCode() { 
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-9: "Anesthesia code" - creates it if necessary
     */
    public ID getPr19_AnesthesiaCode() { 
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-10: "Anesthesia minutes" - creates it if necessary
     */
    public NM getAnesthesiaMinutes() { 
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-10: "Anesthesia minutes" - creates it if necessary
     */
    public NM getPr110_AnesthesiaMinutes() { 
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-11: "Surgeon" - creates it if necessary
     */
    public CN getSurgeon() { 
        CN ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-11: "Surgeon" - creates it if necessary
     */
    public CN getPr111_Surgeon() { 
        CN ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Procedure Practitioner (PR1-12).
     */
    public CM_PRACTITIONER[] getProcedurePractitioner() {
        CM_PRACTITIONER[] ret = null;
        try {
            Type[] t = this.getField(12);  
            ret = new CM_PRACTITIONER[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CM_PRACTITIONER)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PR1-12: "Procedure Practitioner" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CM_PRACTITIONER getProcedurePractitioner(int rep) { 
        CM_PRACTITIONER ret = null;
        try {
            Type t = this.getField(12, rep);
            ret = (CM_PRACTITIONER)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PR1-12: "Procedure Practitioner" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CM_PRACTITIONER getPr112_ProcedurePractitioner(int rep) { 
        CM_PRACTITIONER ret = null;
        try {
            Type t = this.getField(12, rep);
            ret = (CM_PRACTITIONER)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PR1-12: "Procedure Practitioner" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_PRACTITIONER insertProcedurePractitioner(int rep) throws HL7Exception { 
        return (CM_PRACTITIONER) super.insertRepetition(12, rep);
    }



    /**
     * Inserts a repetition of
     * PR1-12: "Procedure Practitioner" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_PRACTITIONER insertPr112_ProcedurePractitioner(int rep) throws HL7Exception { 
        return (CM_PRACTITIONER) super.insertRepetition(12, rep);
    }


    /**
     * Removes a repetition of
     * PR1-12: "Procedure Practitioner" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_PRACTITIONER removeProcedurePractitioner(int rep) throws HL7Exception { 
        return (CM_PRACTITIONER) super.removeRepetition(12, rep);
    }


    /**
     * Removes a repetition of
     * PR1-12: "Procedure Practitioner" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_PRACTITIONER removePr112_ProcedurePractitioner(int rep) throws HL7Exception { 
        return (CM_PRACTITIONER) super.removeRepetition(12, rep);
    }




    /**
     * Returns
     * PR1-13: "Consent code" - creates it if necessary
     */
    public ID getConsentCode() { 
        ID ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-13: "Consent code" - creates it if necessary
     */
    public ID getPr113_ConsentCode() { 
        ID ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PR1-14: "Procedure priority" - creates it if necessary
     */
    public NM getProcedurePriority() { 
        NM ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PR1-14: "Procedure priority" - creates it if necessary
     */
    public NM getPr114_ProcedurePriority() { 
        NM ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new ID(getMessage(), new Integer( 89 ));
          case 2: return new ID(getMessage(), new Integer( 88 ));
          case 3: return new ST(getMessage());
          case 4: return new TS(getMessage());
          case 5: return new ID(getMessage(), new Integer( 90 ));
          case 6: return new NM(getMessage());
          case 7: return new CN(getMessage());
          case 8: return new ID(getMessage(), new Integer( 19 ));
          case 9: return new NM(getMessage());
          case 10: return new CN(getMessage());
          case 11: return new CM_PRACTITIONER(getMessage());
          case 12: return new ID(getMessage(), new Integer( 59 ));
          case 13: return new NM(getMessage());
          default: return null;
       }
   }


}

