/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CM_PRACTITIONER;
import ca.uhn.hl7v2.model.v22.datatype.CN;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.SI;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PR1
extends AbstractSegment {
    public PR1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - procedure");
            this.add(ID.class, true, 0, 2, new Object[]{this.getMessage(), new Integer(89)}, "Procedure coding method");
            this.add(ID.class, true, 0, 10, new Object[]{this.getMessage(), new Integer(88)}, "Procedure code");
            this.add(ST.class, false, 0, 40, new Object[]{this.getMessage()}, "Procedure description");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Procedure date / time");
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(90)}, "Procedure type");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Procedure minutes");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "Anesthesiologist");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(19)}, "Anesthesia code");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Anesthesia minutes");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "Surgeon");
            this.add(CM_PRACTITIONER.class, false, 0, 60, new Object[]{this.getMessage()}, "Procedure Practitioner");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(59)}, "Consent code");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Procedure priority");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating PR1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDProcedure() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getPr11_SetIDProcedure() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID[] getProcedureCodingMethod() {
        ID[] retVal = (ID[])this.getTypedField(2, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getPr12_ProcedureCodingMethod() {
        ID[] retVal = (ID[])this.getTypedField(2, (Type[])new ID[0]);
        return retVal;
    }

    public int getProcedureCodingMethodReps() {
        return this.getReps(2);
    }

    public ID getProcedureCodingMethod(int rep) {
        ID retVal = (ID)this.getTypedField(2, rep);
        return retVal;
    }

    public ID getPr12_ProcedureCodingMethod(int rep) {
        ID retVal = (ID)this.getTypedField(2, rep);
        return retVal;
    }

    public int getPr12_ProcedureCodingMethodReps() {
        return this.getReps(2);
    }

    public ID insertProcedureCodingMethod(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(2, rep);
    }

    public ID insertPr12_ProcedureCodingMethod(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(2, rep);
    }

    public ID removeProcedureCodingMethod(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(2, rep);
    }

    public ID removePr12_ProcedureCodingMethod(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(2, rep);
    }

    public ID[] getProcedureCode() {
        ID[] retVal = (ID[])this.getTypedField(3, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getPr13_ProcedureCode() {
        ID[] retVal = (ID[])this.getTypedField(3, (Type[])new ID[0]);
        return retVal;
    }

    public int getProcedureCodeReps() {
        return this.getReps(3);
    }

    public ID getProcedureCode(int rep) {
        ID retVal = (ID)this.getTypedField(3, rep);
        return retVal;
    }

    public ID getPr13_ProcedureCode(int rep) {
        ID retVal = (ID)this.getTypedField(3, rep);
        return retVal;
    }

    public int getPr13_ProcedureCodeReps() {
        return this.getReps(3);
    }

    public ID insertProcedureCode(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(3, rep);
    }

    public ID insertPr13_ProcedureCode(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(3, rep);
    }

    public ID removeProcedureCode(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(3, rep);
    }

    public ID removePr13_ProcedureCode(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(3, rep);
    }

    public ST[] getProcedureDescription() {
        ST[] retVal = (ST[])this.getTypedField(4, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getPr14_ProcedureDescription() {
        ST[] retVal = (ST[])this.getTypedField(4, (Type[])new ST[0]);
        return retVal;
    }

    public int getProcedureDescriptionReps() {
        return this.getReps(4);
    }

    public ST getProcedureDescription(int rep) {
        ST retVal = (ST)this.getTypedField(4, rep);
        return retVal;
    }

    public ST getPr14_ProcedureDescription(int rep) {
        ST retVal = (ST)this.getTypedField(4, rep);
        return retVal;
    }

    public int getPr14_ProcedureDescriptionReps() {
        return this.getReps(4);
    }

    public ST insertProcedureDescription(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(4, rep);
    }

    public ST insertPr14_ProcedureDescription(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(4, rep);
    }

    public ST removeProcedureDescription(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(4, rep);
    }

    public ST removePr14_ProcedureDescription(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(4, rep);
    }

    public TS getProcedureDateTime() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getPr15_ProcedureDateTime() {
        TS retVal = (TS)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getProcedureType() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getPr16_ProcedureType() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getProcedureMinutes() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getPr17_ProcedureMinutes() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public CN getAnesthesiologist() {
        CN retVal = (CN)this.getTypedField(8, 0);
        return retVal;
    }

    public CN getPr18_Anesthesiologist() {
        CN retVal = (CN)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getAnesthesiaCode() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getPr19_AnesthesiaCode() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getAnesthesiaMinutes() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public NM getPr110_AnesthesiaMinutes() {
        NM retVal = (NM)this.getTypedField(10, 0);
        return retVal;
    }

    public CN getSurgeon() {
        CN retVal = (CN)this.getTypedField(11, 0);
        return retVal;
    }

    public CN getPr111_Surgeon() {
        CN retVal = (CN)this.getTypedField(11, 0);
        return retVal;
    }

    public CM_PRACTITIONER[] getProcedurePractitioner() {
        CM_PRACTITIONER[] retVal = (CM_PRACTITIONER[])this.getTypedField(12, (Type[])new CM_PRACTITIONER[0]);
        return retVal;
    }

    public CM_PRACTITIONER[] getPr112_ProcedurePractitioner() {
        CM_PRACTITIONER[] retVal = (CM_PRACTITIONER[])this.getTypedField(12, (Type[])new CM_PRACTITIONER[0]);
        return retVal;
    }

    public int getProcedurePractitionerReps() {
        return this.getReps(12);
    }

    public CM_PRACTITIONER getProcedurePractitioner(int rep) {
        CM_PRACTITIONER retVal = (CM_PRACTITIONER)this.getTypedField(12, rep);
        return retVal;
    }

    public CM_PRACTITIONER getPr112_ProcedurePractitioner(int rep) {
        CM_PRACTITIONER retVal = (CM_PRACTITIONER)this.getTypedField(12, rep);
        return retVal;
    }

    public int getPr112_ProcedurePractitionerReps() {
        return this.getReps(12);
    }

    public CM_PRACTITIONER insertProcedurePractitioner(int rep) throws HL7Exception {
        return (CM_PRACTITIONER)super.insertRepetition(12, rep);
    }

    public CM_PRACTITIONER insertPr112_ProcedurePractitioner(int rep) throws HL7Exception {
        return (CM_PRACTITIONER)super.insertRepetition(12, rep);
    }

    public CM_PRACTITIONER removeProcedurePractitioner(int rep) throws HL7Exception {
        return (CM_PRACTITIONER)super.removeRepetition(12, rep);
    }

    public CM_PRACTITIONER removePr112_ProcedurePractitioner(int rep) throws HL7Exception {
        return (CM_PRACTITIONER)super.removeRepetition(12, rep);
    }

    public ID getConsentCode() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getPr113_ConsentCode() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    public NM getProcedurePriority() {
        NM retVal = (NM)this.getTypedField(14, 0);
        return retVal;
    }

    public NM getPr114_ProcedurePriority() {
        NM retVal = (NM)this.getTypedField(14, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(89));
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(88));
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new TS(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(90));
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new CN(this.getMessage());
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(19));
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new CN(this.getMessage());
            }
            case 11: {
                return new CM_PRACTITIONER(this.getMessage());
            }
            case 12: {
                return new ID(this.getMessage(), new Integer(59));
            }
            case 13: {
                return new NM(this.getMessage());
            }
        }
        return null;
    }
}

