/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OM3
extends AbstractSegment {
    public OM3(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, false, 1, 3, new Object[]{this.getMessage()}, "Segment Type ID");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Sequence Number - Test/ Observation Master File");
            this.add(ID.class, false, 1, 5, new Object[]{this.getMessage(), new Integer(0)}, "Preferred Coding System");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage()}, "Valid coded answers");
            this.add(CE.class, false, 0, 200, new Object[]{this.getMessage()}, "Normal test codes for categorical observations");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Abnormal test codes for categorical observations");
            this.add(CE.class, false, 1, 200, new Object[]{this.getMessage()}, "Critical test codes for categorical observations");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(0)}, "Data Type");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OM3 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST getSegmentTypeID() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getOm31_SegmentTypeID() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getSequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getOm32_SequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getPreferredCodingSystem() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getOm33_PreferredCodingSystem() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public CE[] getValidCodedAnswers() {
        CE[] retVal = (CE[])this.getTypedField(4, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getOm34_ValidCodedAnswers() {
        CE[] retVal = (CE[])this.getTypedField(4, (Type[])new CE[0]);
        return retVal;
    }

    public int getValidCodedAnswersReps() {
        return this.getReps(4);
    }

    public CE getValidCodedAnswers(int rep) {
        CE retVal = (CE)this.getTypedField(4, rep);
        return retVal;
    }

    public CE getOm34_ValidCodedAnswers(int rep) {
        CE retVal = (CE)this.getTypedField(4, rep);
        return retVal;
    }

    public int getOm34_ValidCodedAnswersReps() {
        return this.getReps(4);
    }

    public CE insertValidCodedAnswers(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(4, rep);
    }

    public CE insertOm34_ValidCodedAnswers(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(4, rep);
    }

    public CE removeValidCodedAnswers(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(4, rep);
    }

    public CE removeOm34_ValidCodedAnswers(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(4, rep);
    }

    public CE[] getNormalTestCodesForCategoricalObservations() {
        CE[] retVal = (CE[])this.getTypedField(5, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getOm35_NormalTestCodesForCategoricalObservations() {
        CE[] retVal = (CE[])this.getTypedField(5, (Type[])new CE[0]);
        return retVal;
    }

    public int getNormalTestCodesForCategoricalObservationsReps() {
        return this.getReps(5);
    }

    public CE getNormalTestCodesForCategoricalObservations(int rep) {
        CE retVal = (CE)this.getTypedField(5, rep);
        return retVal;
    }

    public CE getOm35_NormalTestCodesForCategoricalObservations(int rep) {
        CE retVal = (CE)this.getTypedField(5, rep);
        return retVal;
    }

    public int getOm35_NormalTestCodesForCategoricalObservationsReps() {
        return this.getReps(5);
    }

    public CE insertNormalTestCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(5, rep);
    }

    public CE insertOm35_NormalTestCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(5, rep);
    }

    public CE removeNormalTestCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(5, rep);
    }

    public CE removeOm35_NormalTestCodesForCategoricalObservations(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(5, rep);
    }

    public CE getAbnormalTestCodesForCategoricalObservations() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getOm36_AbnormalTestCodesForCategoricalObservations() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getCriticalTestCodesForCategoricalObservations() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getOm37_CriticalTestCodesForCategoricalObservations() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getDataType() {
        ID retVal = (ID)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getOm38_DataType() {
        ID retVal = (ID)this.getTypedField(8, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new ID(this.getMessage(), new Integer(0));
            }
        }
        return null;
    }
}

