/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CM_CSU (channel sensitivity/units) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>sensitivity (NM)
 * <li>units identifier (ID)
 * <li>units text (ST)
 * <li>units name of coding system (ST)
 * <li>units alternate identifier (ID)
 * <li>units alternate text (ST)
 * <li>units name of alternate coding system (ST)
 * </ul>
 */
public class CM_CSU extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CM_CSU type
     */
    public CM_CSU(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[7];    
        data[0] = new NM(getMessage());
        data[1] = new ID(getMessage(), 0);
        data[2] = new ST(getMessage());
        data[3] = new ST(getMessage());
        data[4] = new ID(getMessage(), 0);
        data[5] = new ST(getMessage());
        data[6] = new ST(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns sensitivity (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getSensitivity() {
       NM ret = null;
       try {
          ret = (NM)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns sensitivity (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCm_csu1_Sensitivity() {
       NM ret = null;
       try {
          ret = (NM)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns units identifier (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getUnitsIdentifier() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns units identifier (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCm_csu2_UnitsIdentifier() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns units text (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getUnitsText() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns units text (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_csu3_UnitsText() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns units name of coding system (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getUnitsNameOfCodingSystem() {
       ST ret = null;
       try {
          ret = (ST)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns units name of coding system (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_csu4_UnitsNameOfCodingSystem() {
       ST ret = null;
       try {
          ret = (ST)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns units alternate identifier (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getUnitsAlternateIdentifier() {
       ID ret = null;
       try {
          ret = (ID)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns units alternate identifier (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCm_csu5_UnitsAlternateIdentifier() {
       ID ret = null;
       try {
          ret = (ID)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns units alternate text (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getUnitsAlternateText() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns units alternate text (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_csu6_UnitsAlternateText() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns units name of alternate coding system (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getUnitsNameOfAlternateCodingSystem() {
       ST ret = null;
       try {
          ret = (ST)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns units name of alternate coding system (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_csu7_UnitsNameOfAlternateCodingSystem() {
       ST ret = null;
       try {
          ret = (ST)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

