/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.model.v23.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a CSU_C09_STUDY_SCHEDULE group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: CSS (Clinical Study Data Schedule) <b>optional </b></li>
                 * <li>2: CSU_C09_STUDY_OBSERVATION (a Group object) <b>optional repeating</b></li>
                 * <li>3: CSU_C09_STUDY_PHARM (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class CSU_C09_STUDY_SCHEDULE extends AbstractGroup {

    /** 
     * Creates a new CSU_C09_STUDY_SCHEDULE group
     */
    public CSU_C09_STUDY_SCHEDULE(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(CSS.class, false, false);
                          this.add(CSU_C09_STUDY_OBSERVATION.class, false, true);
                          this.add(CSU_C09_STUDY_PHARM.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating CSU_C09_STUDY_SCHEDULE - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3"
     */
    public String getVersion() {
       return "2.3";
    }



    /**
     * Returns
     * CSS (Clinical Study Data Schedule) - creates it if necessary
     */
    public CSS getCSS() { 
       CSS ret = null;
       try {
          ret = (CSS)this.get("CSS");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * STUDY_OBSERVATION (a Group object) - creates it if necessary
     */
    public CSU_C09_STUDY_OBSERVATION getSTUDY_OBSERVATION() { 
       CSU_C09_STUDY_OBSERVATION ret = null;
       try {
          ret = (CSU_C09_STUDY_OBSERVATION)this.get("STUDY_OBSERVATION");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * STUDY_OBSERVATION (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public CSU_C09_STUDY_OBSERVATION getSTUDY_OBSERVATION(int rep) { 
       CSU_C09_STUDY_OBSERVATION ret = null;
       try {
          ret = (CSU_C09_STUDY_OBSERVATION)this.get("STUDY_OBSERVATION", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of STUDY_OBSERVATION 
     */ 
    public int getSTUDY_OBSERVATIONReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("STUDY_OBSERVATION").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of STUDY_OBSERVATION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertSTUDY_OBSERVATION(CSU_C09_STUDY_OBSERVATION structure, int rep) throws HL7Exception { 
       super.insertRepetition("STUDY_OBSERVATION", structure, rep);
    }


    /**
     * Inserts a specific repetition of STUDY_OBSERVATION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public CSU_C09_STUDY_OBSERVATION insertSTUDY_OBSERVATION(int rep) throws HL7Exception { 
       return (CSU_C09_STUDY_OBSERVATION)super.insertRepetition("STUDY_OBSERVATION", rep);
    }


    /**
     * Removes a specific repetition of STUDY_OBSERVATION (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public CSU_C09_STUDY_OBSERVATION removeSTUDY_OBSERVATION(int rep) throws HL7Exception { 
       return (CSU_C09_STUDY_OBSERVATION)super.removeRepetition("STUDY_OBSERVATION", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * STUDY_PHARM (a Group object) - creates it if necessary
     */
    public CSU_C09_STUDY_PHARM getSTUDY_PHARM() { 
       CSU_C09_STUDY_PHARM ret = null;
       try {
          ret = (CSU_C09_STUDY_PHARM)this.get("STUDY_PHARM");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * STUDY_PHARM (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public CSU_C09_STUDY_PHARM getSTUDY_PHARM(int rep) { 
       CSU_C09_STUDY_PHARM ret = null;
       try {
          ret = (CSU_C09_STUDY_PHARM)this.get("STUDY_PHARM", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of STUDY_PHARM 
     */ 
    public int getSTUDY_PHARMReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("STUDY_PHARM").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of STUDY_PHARM (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertSTUDY_PHARM(CSU_C09_STUDY_PHARM structure, int rep) throws HL7Exception { 
       super.insertRepetition("STUDY_PHARM", structure, rep);
    }


    /**
     * Inserts a specific repetition of STUDY_PHARM (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public CSU_C09_STUDY_PHARM insertSTUDY_PHARM(int rep) throws HL7Exception { 
       return (CSU_C09_STUDY_PHARM)super.insertRepetition("STUDY_PHARM", rep);
    }


    /**
     * Removes a specific repetition of STUDY_PHARM (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public CSU_C09_STUDY_PHARM removeSTUDY_PHARM(int rep) throws HL7Exception { 
       return (CSU_C09_STUDY_PHARM)super.removeRepetition("STUDY_PHARM", rep);
    }



}

