/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.model.v23.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a MFN_M08_xx group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: OM2 (Numeric observation) <b>optional </b></li>
                 * <li>2: OM3 (Categorical test/observation) <b>optional </b></li>
                 * <li>3: OM4 (Observations that require specimens) <b>optional </b></li>
 * </ul>
 */
public class MFN_M08_xx extends AbstractGroup {

    /** 
     * Creates a new MFN_M08_xx group
     */
    public MFN_M08_xx(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(OM2.class, false, false);
                          this.add(OM3.class, false, false);
                          this.add(OM4.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MFN_M08_xx - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3"
     */
    public String getVersion() {
       return "2.3";
    }



    /**
     * Returns
     * OM2 (Numeric observation) - creates it if necessary
     */
    public OM2 getOM2() { 
       OM2 ret = null;
       try {
          ret = (OM2)this.get("OM2");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * OM3 (Categorical test/observation) - creates it if necessary
     */
    public OM3 getOM3() { 
       OM3 ret = null;
       try {
          ret = (OM3)this.get("OM3");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * OM4 (Observations that require specimens) - creates it if necessary
     */
    public OM4 getOM4() { 
       OM4 ret = null;
       try {
          ret = (OM4)this.get("OM4");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

