/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.model.v23.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a SRM_S10_RESOURCES group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: RGS (Resource Group) <b> </b></li>
                 * <li>2: SRM_S10_SERVICE (a Group object) <b>optional repeating</b></li>
                 * <li>3: SRM_S10_GENERAL_RESOURCE (a Group object) <b>optional repeating</b></li>
                 * <li>4: SRM_S10_LOCATION_RESOURCE (a Group object) <b>optional repeating</b></li>
                 * <li>5: SRM_S10_PERSONNEL_RESOURCE (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class SRM_S10_RESOURCES extends AbstractGroup {

    /** 
     * Creates a new SRM_S10_RESOURCES group
     */
    public SRM_S10_RESOURCES(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(RGS.class, true, false);
                          this.add(SRM_S10_SERVICE.class, false, true);
                          this.add(SRM_S10_GENERAL_RESOURCE.class, false, true);
                          this.add(SRM_S10_LOCATION_RESOURCE.class, false, true);
                          this.add(SRM_S10_PERSONNEL_RESOURCE.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating SRM_S10_RESOURCES - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3"
     */
    public String getVersion() {
       return "2.3";
    }



    /**
     * Returns
     * RGS (Resource Group) - creates it if necessary
     */
    public RGS getRGS() { 
       RGS ret = null;
       try {
          ret = (RGS)this.get("RGS");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * SERVICE (a Group object) - creates it if necessary
     */
    public SRM_S10_SERVICE getSERVICE() { 
       SRM_S10_SERVICE ret = null;
       try {
          ret = (SRM_S10_SERVICE)this.get("SERVICE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * SERVICE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SRM_S10_SERVICE getSERVICE(int rep) { 
       SRM_S10_SERVICE ret = null;
       try {
          ret = (SRM_S10_SERVICE)this.get("SERVICE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of SERVICE 
     */ 
    public int getSERVICEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("SERVICE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of SERVICE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertSERVICE(SRM_S10_SERVICE structure, int rep) throws HL7Exception { 
       super.insertRepetition("SERVICE", structure, rep);
    }


    /**
     * Inserts a specific repetition of SERVICE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SRM_S10_SERVICE insertSERVICE(int rep) throws HL7Exception { 
       return (SRM_S10_SERVICE)super.insertRepetition("SERVICE", rep);
    }


    /**
     * Removes a specific repetition of SERVICE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SRM_S10_SERVICE removeSERVICE(int rep) throws HL7Exception { 
       return (SRM_S10_SERVICE)super.removeRepetition("SERVICE", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * GENERAL_RESOURCE (a Group object) - creates it if necessary
     */
    public SRM_S10_GENERAL_RESOURCE getGENERAL_RESOURCE() { 
       SRM_S10_GENERAL_RESOURCE ret = null;
       try {
          ret = (SRM_S10_GENERAL_RESOURCE)this.get("GENERAL_RESOURCE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * GENERAL_RESOURCE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SRM_S10_GENERAL_RESOURCE getGENERAL_RESOURCE(int rep) { 
       SRM_S10_GENERAL_RESOURCE ret = null;
       try {
          ret = (SRM_S10_GENERAL_RESOURCE)this.get("GENERAL_RESOURCE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of GENERAL_RESOURCE 
     */ 
    public int getGENERAL_RESOURCEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("GENERAL_RESOURCE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of GENERAL_RESOURCE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertGENERAL_RESOURCE(SRM_S10_GENERAL_RESOURCE structure, int rep) throws HL7Exception { 
       super.insertRepetition("GENERAL_RESOURCE", structure, rep);
    }


    /**
     * Inserts a specific repetition of GENERAL_RESOURCE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SRM_S10_GENERAL_RESOURCE insertGENERAL_RESOURCE(int rep) throws HL7Exception { 
       return (SRM_S10_GENERAL_RESOURCE)super.insertRepetition("GENERAL_RESOURCE", rep);
    }


    /**
     * Removes a specific repetition of GENERAL_RESOURCE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SRM_S10_GENERAL_RESOURCE removeGENERAL_RESOURCE(int rep) throws HL7Exception { 
       return (SRM_S10_GENERAL_RESOURCE)super.removeRepetition("GENERAL_RESOURCE", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * LOCATION_RESOURCE (a Group object) - creates it if necessary
     */
    public SRM_S10_LOCATION_RESOURCE getLOCATION_RESOURCE() { 
       SRM_S10_LOCATION_RESOURCE ret = null;
       try {
          ret = (SRM_S10_LOCATION_RESOURCE)this.get("LOCATION_RESOURCE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * LOCATION_RESOURCE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SRM_S10_LOCATION_RESOURCE getLOCATION_RESOURCE(int rep) { 
       SRM_S10_LOCATION_RESOURCE ret = null;
       try {
          ret = (SRM_S10_LOCATION_RESOURCE)this.get("LOCATION_RESOURCE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of LOCATION_RESOURCE 
     */ 
    public int getLOCATION_RESOURCEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("LOCATION_RESOURCE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of LOCATION_RESOURCE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertLOCATION_RESOURCE(SRM_S10_LOCATION_RESOURCE structure, int rep) throws HL7Exception { 
       super.insertRepetition("LOCATION_RESOURCE", structure, rep);
    }


    /**
     * Inserts a specific repetition of LOCATION_RESOURCE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SRM_S10_LOCATION_RESOURCE insertLOCATION_RESOURCE(int rep) throws HL7Exception { 
       return (SRM_S10_LOCATION_RESOURCE)super.insertRepetition("LOCATION_RESOURCE", rep);
    }


    /**
     * Removes a specific repetition of LOCATION_RESOURCE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SRM_S10_LOCATION_RESOURCE removeLOCATION_RESOURCE(int rep) throws HL7Exception { 
       return (SRM_S10_LOCATION_RESOURCE)super.removeRepetition("LOCATION_RESOURCE", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * PERSONNEL_RESOURCE (a Group object) - creates it if necessary
     */
    public SRM_S10_PERSONNEL_RESOURCE getPERSONNEL_RESOURCE() { 
       SRM_S10_PERSONNEL_RESOURCE ret = null;
       try {
          ret = (SRM_S10_PERSONNEL_RESOURCE)this.get("PERSONNEL_RESOURCE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PERSONNEL_RESOURCE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SRM_S10_PERSONNEL_RESOURCE getPERSONNEL_RESOURCE(int rep) { 
       SRM_S10_PERSONNEL_RESOURCE ret = null;
       try {
          ret = (SRM_S10_PERSONNEL_RESOURCE)this.get("PERSONNEL_RESOURCE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PERSONNEL_RESOURCE 
     */ 
    public int getPERSONNEL_RESOURCEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PERSONNEL_RESOURCE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PERSONNEL_RESOURCE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertPERSONNEL_RESOURCE(SRM_S10_PERSONNEL_RESOURCE structure, int rep) throws HL7Exception { 
       super.insertRepetition("PERSONNEL_RESOURCE", structure, rep);
    }


    /**
     * Inserts a specific repetition of PERSONNEL_RESOURCE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public SRM_S10_PERSONNEL_RESOURCE insertPERSONNEL_RESOURCE(int rep) throws HL7Exception { 
       return (SRM_S10_PERSONNEL_RESOURCE)super.insertRepetition("PERSONNEL_RESOURCE", rep);
    }


    /**
     * Removes a specific repetition of PERSONNEL_RESOURCE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public SRM_S10_PERSONNEL_RESOURCE removePERSONNEL_RESOURCE(int rep) throws HL7Exception { 
       return (SRM_S10_PERSONNEL_RESOURCE)super.removeRepetition("PERSONNEL_RESOURCE", rep);
    }



}

