/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.model.v23.group.*;
import ca.uhn.hl7v2.model.v23.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a ADR_A19 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message header segment) <b> </b></li>
                 * <li>2: MSA (Message acknowledgement segment) <b> </b></li>
                 * <li>3: ERR (Error segment) <b>optional </b></li>
                 * <li>4: QRD (Query definition segment) <b> </b></li>
                 * <li>5: QRF (Query filter segment) <b>optional </b></li>
                 * <li>6: ADR_A19_QUERY_RESPONSE (a Group object) <b> repeating</b></li>
                 * <li>7: DSC (Continuation pointer segment) <b>optional </b></li>
 * </ul>
 */
public class ADR_A19 extends AbstractMessage  {

    /** 
     * Creates a new ADR_A19 message with custom ModelClassFactory.
     */
    public ADR_A19(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    /**
     * Creates a new ADR_A19 message with DefaultModelClassFactory. 
     */ 
    public ADR_A19() { 
       super(new DefaultModelClassFactory());
       init(new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(MSA.class, true, false);
                          this.add(ERR.class, false, false);
                          this.add(QRD.class, true, false);
                          this.add(QRF.class, false, false);
                          this.add(ADR_A19_QUERY_RESPONSE.class, true, true);
                          this.add(DSC.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ADR_A19 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3"
     */
    public String getVersion() {
       return "2.3";
    }



    /**
     * Returns
     * MSH (Message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * MSA (Message acknowledgement segment) - creates it if necessary
     */
    public MSA getMSA() { 
       MSA ret = null;
       try {
          ret = (MSA)this.get("MSA");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * ERR (Error segment) - creates it if necessary
     */
    public ERR getERR() { 
       ERR ret = null;
       try {
          ret = (ERR)this.get("ERR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * QRD (Query definition segment) - creates it if necessary
     */
    public QRD getQRD() { 
       QRD ret = null;
       try {
          ret = (QRD)this.get("QRD");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * QRF (Query filter segment) - creates it if necessary
     */
    public QRF getQRF() { 
       QRF ret = null;
       try {
          ret = (QRF)this.get("QRF");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * QUERY_RESPONSE (a Group object) - creates it if necessary
     */
    public ADR_A19_QUERY_RESPONSE getQUERY_RESPONSE() { 
       ADR_A19_QUERY_RESPONSE ret = null;
       try {
          ret = (ADR_A19_QUERY_RESPONSE)this.get("QUERY_RESPONSE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * QUERY_RESPONSE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ADR_A19_QUERY_RESPONSE getQUERY_RESPONSE(int rep) { 
       ADR_A19_QUERY_RESPONSE ret = null;
       try {
          ret = (ADR_A19_QUERY_RESPONSE)this.get("QUERY_RESPONSE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of QUERY_RESPONSE 
     */ 
    public int getQUERY_RESPONSEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("QUERY_RESPONSE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of QUERY_RESPONSE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertQUERY_RESPONSE(ADR_A19_QUERY_RESPONSE structure, int rep) throws HL7Exception { 
       super.insertRepetition( "QUERY_RESPONSE", structure, rep);
    }


    /**
     * Inserts a specific repetition of QUERY_RESPONSE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public ADR_A19_QUERY_RESPONSE insertQUERY_RESPONSE(int rep) throws HL7Exception { 
       return (ADR_A19_QUERY_RESPONSE)super.insertRepetition("QUERY_RESPONSE", rep);
    }


    /**
     * Removes a specific repetition of QUERY_RESPONSE (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public ADR_A19_QUERY_RESPONSE removeQUERY_RESPONSE(int rep) throws HL7Exception { 
       return (ADR_A19_QUERY_RESPONSE)super.removeRepetition("QUERY_RESPONSE", rep);
    }



    /**
     * Returns
     * DSC (Continuation pointer segment) - creates it if necessary
     */
    public DSC getDSC() { 
       DSC ret = null;
       try {
          ret = (DSC)this.get("DSC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

