/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.model.v23.group.*;
import ca.uhn.hl7v2.model.v23.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a RGR_RGR message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message header segment) <b> </b></li>
                 * <li>2: MSA (Message acknowledgement segment) <b> </b></li>
                 * <li>3: ERR (Error segment) <b>optional </b></li>
                 * <li>4: RGR_RGR_DEFINITION (a Group object) <b> repeating</b></li>
                 * <li>5: DSC (Continuation pointer segment) <b>optional </b></li>
 * </ul>
 */
public class RGR_RGR extends AbstractMessage  {

    /** 
     * Creates a new RGR_RGR message with custom ModelClassFactory.
     */
    public RGR_RGR(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    /**
     * Creates a new RGR_RGR message with DefaultModelClassFactory. 
     */ 
    public RGR_RGR() { 
       super(new DefaultModelClassFactory());
       init(new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(MSA.class, true, false);
                          this.add(ERR.class, false, false);
                          this.add(RGR_RGR_DEFINITION.class, true, true);
                          this.add(DSC.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RGR_RGR - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3"
     */
    public String getVersion() {
       return "2.3";
    }



    /**
     * Returns
     * MSH (Message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * MSA (Message acknowledgement segment) - creates it if necessary
     */
    public MSA getMSA() { 
       MSA ret = null;
       try {
          ret = (MSA)this.get("MSA");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * ERR (Error segment) - creates it if necessary
     */
    public ERR getERR() { 
       ERR ret = null;
       try {
          ret = (ERR)this.get("ERR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * DEFINITION (a Group object) - creates it if necessary
     */
    public RGR_RGR_DEFINITION getDEFINITION() { 
       RGR_RGR_DEFINITION ret = null;
       try {
          ret = (RGR_RGR_DEFINITION)this.get("DEFINITION");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * DEFINITION (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public RGR_RGR_DEFINITION getDEFINITION(int rep) { 
       RGR_RGR_DEFINITION ret = null;
       try {
          ret = (RGR_RGR_DEFINITION)this.get("DEFINITION", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of DEFINITION 
     */ 
    public int getDEFINITIONReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("DEFINITION").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of DEFINITION (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertDEFINITION(RGR_RGR_DEFINITION structure, int rep) throws HL7Exception { 
       super.insertRepetition( "DEFINITION", structure, rep);
    }


    /**
     * Inserts a specific repetition of DEFINITION (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public RGR_RGR_DEFINITION insertDEFINITION(int rep) throws HL7Exception { 
       return (RGR_RGR_DEFINITION)super.insertRepetition("DEFINITION", rep);
    }


    /**
     * Removes a specific repetition of DEFINITION (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public RGR_RGR_DEFINITION removeDEFINITION(int rep) throws HL7Exception { 
       return (RGR_RGR_DEFINITION)super.removeRepetition("DEFINITION", rep);
    }



    /**
     * Returns
     * DSC (Continuation pointer segment) - creates it if necessary
     */
    public DSC getDSC() { 
       DSC ret = null;
       try {
          ret = (DSC)this.get("DSC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

