/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.model.v23.group.*;
import ca.uhn.hl7v2.model.v23.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a RQC_I06 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message header segment) <b> </b></li>
                 * <li>2: QRD (Query definition segment) <b> </b></li>
                 * <li>3: QRF (Query filter segment) <b>optional </b></li>
                 * <li>4: RQC_I06_PROVIDER (a Group object) <b> repeating</b></li>
                 * <li>5: PID (Patient Identification) <b> </b></li>
                 * <li>6: NK1 (Next of kin) <b>optional repeating</b></li>
                 * <li>7: GT1 (Guarantor) <b>optional </b></li>
                 * <li>8: NTE (Notes and comments segment) <b>optional repeating</b></li>
 * </ul>
 */
public class RQC_I06 extends AbstractMessage  {

    /** 
     * Creates a new RQC_I06 message with custom ModelClassFactory.
     */
    public RQC_I06(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    /**
     * Creates a new RQC_I06 message with DefaultModelClassFactory. 
     */ 
    public RQC_I06() { 
       super(new DefaultModelClassFactory());
       init(new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(QRD.class, true, false);
                          this.add(QRF.class, false, false);
                          this.add(RQC_I06_PROVIDER.class, true, true);
                          this.add(PID.class, true, false);
                          this.add(NK1.class, false, true);
                          this.add(GT1.class, false, false);
                          this.add(NTE.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RQC_I06 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3"
     */
    public String getVersion() {
       return "2.3";
    }



    /**
     * Returns
     * MSH (Message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * QRD (Query definition segment) - creates it if necessary
     */
    public QRD getQRD() { 
       QRD ret = null;
       try {
          ret = (QRD)this.get("QRD");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * QRF (Query filter segment) - creates it if necessary
     */
    public QRF getQRF() { 
       QRF ret = null;
       try {
          ret = (QRF)this.get("QRF");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * PROVIDER (a Group object) - creates it if necessary
     */
    public RQC_I06_PROVIDER getPROVIDER() { 
       RQC_I06_PROVIDER ret = null;
       try {
          ret = (RQC_I06_PROVIDER)this.get("PROVIDER");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PROVIDER (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public RQC_I06_PROVIDER getPROVIDER(int rep) { 
       RQC_I06_PROVIDER ret = null;
       try {
          ret = (RQC_I06_PROVIDER)this.get("PROVIDER", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PROVIDER 
     */ 
    public int getPROVIDERReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PROVIDER").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PROVIDER (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertPROVIDER(RQC_I06_PROVIDER structure, int rep) throws HL7Exception { 
       super.insertRepetition( "PROVIDER", structure, rep);
    }


    /**
     * Inserts a specific repetition of PROVIDER (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public RQC_I06_PROVIDER insertPROVIDER(int rep) throws HL7Exception { 
       return (RQC_I06_PROVIDER)super.insertRepetition("PROVIDER", rep);
    }


    /**
     * Removes a specific repetition of PROVIDER (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public RQC_I06_PROVIDER removePROVIDER(int rep) throws HL7Exception { 
       return (RQC_I06_PROVIDER)super.removeRepetition("PROVIDER", rep);
    }



    /**
     * Returns
     * PID (Patient Identification) - creates it if necessary
     */
    public PID getPID() { 
       PID ret = null;
       try {
          ret = (PID)this.get("PID");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * NK1 (Next of kin) - creates it if necessary
     */
    public NK1 getNK1() { 
       NK1 ret = null;
       try {
          ret = (NK1)this.get("NK1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NK1 (Next of kin) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NK1 getNK1(int rep) { 
       NK1 ret = null;
       try {
          ret = (NK1)this.get("NK1", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NK1 
     */ 
    public int getNK1Reps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NK1").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NK1 (Next of kin)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertNK1(NK1 structure, int rep) throws HL7Exception { 
       super.insertRepetition( "NK1", structure, rep);
    }


    /**
     * Inserts a specific repetition of NK1 (Next of kin)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public NK1 insertNK1(int rep) throws HL7Exception { 
       return (NK1)super.insertRepetition("NK1", rep);
    }


    /**
     * Removes a specific repetition of NK1 (Next of kin)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public NK1 removeNK1(int rep) throws HL7Exception { 
       return (NK1)super.removeRepetition("NK1", rep);
    }



    /**
     * Returns
     * GT1 (Guarantor) - creates it if necessary
     */
    public GT1 getGT1() { 
       GT1 ret = null;
       try {
          ret = (GT1)this.get("GT1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * NTE (Notes and comments segment) - creates it if necessary
     */
    public NTE getNTE() { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * NTE (Notes and comments segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NTE getNTE(int rep) { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of NTE 
     */ 
    public int getNTEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("NTE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of NTE (Notes and comments segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertNTE(NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition( "NTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of NTE (Notes and comments segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public NTE insertNTE(int rep) throws HL7Exception { 
       return (NTE)super.insertRepetition("NTE", rep);
    }


    /**
     * Removes a specific repetition of NTE (Notes and comments segment)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public NTE removeNTE(int rep) throws HL7Exception { 
       return (NTE)super.removeRepetition("NTE", rep);
    }



}

