/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.model.v23.group.*;
import ca.uhn.hl7v2.model.v23.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a SQR_S25 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message header segment) <b> </b></li>
                 * <li>2: MSA (Message acknowledgement segment) <b> </b></li>
                 * <li>3: ERR (Error segment) <b>optional </b></li>
                 * <li>4: QAK (Query Acknowledgement) <b> </b></li>
                 * <li>5: SQR_S25_SCHEDULE (a Group object) <b>optional repeating</b></li>
                 * <li>6: DSC (Continuation pointer segment) <b>optional </b></li>
 * </ul>
 */
public class SQR_S25 extends AbstractMessage  {

    /** 
     * Creates a new SQR_S25 message with custom ModelClassFactory.
     */
    public SQR_S25(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    /**
     * Creates a new SQR_S25 message with DefaultModelClassFactory. 
     */ 
    public SQR_S25() { 
       super(new DefaultModelClassFactory());
       init(new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(MSA.class, true, false);
                          this.add(ERR.class, false, false);
                          this.add(QAK.class, true, false);
                          this.add(SQR_S25_SCHEDULE.class, false, true);
                          this.add(DSC.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating SQR_S25 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.3"
     */
    public String getVersion() {
       return "2.3";
    }



    /**
     * Returns
     * MSH (Message header segment) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * MSA (Message acknowledgement segment) - creates it if necessary
     */
    public MSA getMSA() { 
       MSA ret = null;
       try {
          ret = (MSA)this.get("MSA");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * ERR (Error segment) - creates it if necessary
     */
    public ERR getERR() { 
       ERR ret = null;
       try {
          ret = (ERR)this.get("ERR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * QAK (Query Acknowledgement) - creates it if necessary
     */
    public QAK getQAK() { 
       QAK ret = null;
       try {
          ret = (QAK)this.get("QAK");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * SCHEDULE (a Group object) - creates it if necessary
     */
    public SQR_S25_SCHEDULE getSCHEDULE() { 
       SQR_S25_SCHEDULE ret = null;
       try {
          ret = (SQR_S25_SCHEDULE)this.get("SCHEDULE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * SCHEDULE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SQR_S25_SCHEDULE getSCHEDULE(int rep) { 
       SQR_S25_SCHEDULE ret = null;
       try {
          ret = (SQR_S25_SCHEDULE)this.get("SCHEDULE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of SCHEDULE 
     */ 
    public int getSCHEDULEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("SCHEDULE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of SCHEDULE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertSCHEDULE(SQR_S25_SCHEDULE structure, int rep) throws HL7Exception { 
       super.insertRepetition( "SCHEDULE", structure, rep);
    }


    /**
     * Inserts a specific repetition of SCHEDULE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public SQR_S25_SCHEDULE insertSCHEDULE(int rep) throws HL7Exception { 
       return (SQR_S25_SCHEDULE)super.insertRepetition("SCHEDULE", rep);
    }


    /**
     * Removes a specific repetition of SCHEDULE (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public SQR_S25_SCHEDULE removeSCHEDULE(int rep) throws HL7Exception { 
       return (SQR_S25_SCHEDULE)super.removeRepetition("SCHEDULE", rep);
    }



    /**
     * Returns
     * DSC (Continuation pointer segment) - creates it if necessary
     */
    public DSC getDSC() { 
       DSC ret = null;
       try {
          ret = (DSC)this.get("DSC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

