/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.segment;

// import ca.uhn.hl7v2.model.v23.group.*;
import ca.uhn.hl7v2.model.v23.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 IN3 message segment (Insurance additional info - certification). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>IN3-1: Set ID - Insurance Certification (SI) <b> </b>
     * <li>IN3-2: Certification Number (CX) <b>optional </b>
     * <li>IN3-3: Certified By (XCN) <b>optional repeating</b>
     * <li>IN3-4: Certification Required (ID) <b>optional </b>
     * <li>IN3-5: Penalty (CM_PEN) <b>optional </b>
     * <li>IN3-6: Certification Date/Time (TS) <b>optional </b>
     * <li>IN3-7: Certification Modify Date/Time (TS) <b>optional </b>
     * <li>IN3-8: Operator (XCN) <b>optional repeating</b>
     * <li>IN3-9: Certification Begin Date (DT) <b>optional </b>
     * <li>IN3-10: Certification End Date (DT) <b>optional </b>
     * <li>IN3-11: Days (CM_DTN) <b>optional </b>
     * <li>IN3-12: Non-Concur Code/Description (CE) <b>optional </b>
     * <li>IN3-13: Non-Concur Effective Date/Time (TS) <b>optional </b>
     * <li>IN3-14: Physician Reviewer (XCN) <b>optional repeating</b>
     * <li>IN3-15: Certification Contact (ST) <b>optional </b>
     * <li>IN3-16: Certification Contact Phone Number (XTN) <b>optional repeating</b>
     * <li>IN3-17: Appeal Reason (CE) <b>optional </b>
     * <li>IN3-18: Certification Agency (CE) <b>optional </b>
     * <li>IN3-19: Certification Agency Phone Number (XTN) <b>optional repeating</b>
     * <li>IN3-20: Pre-Certification required/Window (CM_PCF) <b>optional repeating</b>
     * <li>IN3-21: Case Manager (ST) <b>optional </b>
     * <li>IN3-22: Second Opinion Date (DT) <b>optional </b>
     * <li>IN3-23: Second Opinion Status (IS) <b>optional </b>
     * <li>IN3-24: Second Opinion Documentation Received (IS) <b>optional repeating</b>
     * <li>IN3-25: Second Opinion Physician (XCN) <b>optional repeating</b>
 * </ul>
 */
public class IN3 extends AbstractSegment {

    /** 
     * Creates a new IN3 segment
     */
    public IN3(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Set ID - Insurance Certification");
                                  this.add(CX.class, false, 1, 59, new Object[]{ getMessage(), new Integer(0) }, "Certification Number");
                                  this.add(XCN.class, false, 0, 60, new Object[]{ getMessage(), new Integer(0) }, "Certified By");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Certification Required");
                                  this.add(CM_PEN.class, false, 1, 10, new Object[]{ getMessage(), new Integer(148) }, "Penalty");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Certification Date/Time");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Certification Modify Date/Time");
                                  this.add(XCN.class, false, 0, 60, new Object[]{ getMessage(), new Integer(0) }, "Operator");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Certification Begin Date");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Certification End Date");
                                  this.add(CM_DTN.class, false, 1, 3, new Object[]{ getMessage(), new Integer(149) }, "Days");
                                  this.add(CE.class, false, 1, 60, new Object[]{ getMessage(), new Integer(233) }, "Non-Concur Code/Description");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Non-Concur Effective Date/Time");
                                  this.add(XCN.class, false, 0, 60, new Object[]{ getMessage(), new Integer(0) }, "Physician Reviewer");
                                  this.add(ST.class, false, 1, 48, new Object[]{ getMessage(), new Integer(0) }, "Certification Contact");
                                  this.add(XTN.class, false, 0, 40, new Object[]{ getMessage(), new Integer(0) }, "Certification Contact Phone Number");
                                  this.add(CE.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Appeal Reason");
                                  this.add(CE.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Certification Agency");
                                  this.add(XTN.class, false, 0, 40, new Object[]{ getMessage(), new Integer(0) }, "Certification Agency Phone Number");
                                  this.add(CM_PCF.class, false, 0, 40, new Object[]{ getMessage(), new Integer(0) }, "Pre-Certification required/Window");
                                  this.add(ST.class, false, 1, 48, new Object[]{ getMessage(), new Integer(0) }, "Case Manager");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Second Opinion Date");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Second Opinion Status");
                                  this.add(IS.class, false, 0, 1, new Object[]{ getMessage() }, "Second Opinion Documentation Received");
                                  this.add(XCN.class, false, 0, 60, new Object[]{ getMessage(), new Integer(0) }, "Second Opinion Physician");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating IN3 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * IN3-1: "Set ID - Insurance Certification" - creates it if necessary
     */
    public SI getSetIDInsuranceCertification() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN3-1: "Set ID - Insurance Certification" - creates it if necessary
     */
    public SI getIn31_SetIDInsuranceCertification() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN3-2: "Certification Number" - creates it if necessary
     */
    public CX getCertificationNumber() { 
        CX ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN3-2: "Certification Number" - creates it if necessary
     */
    public CX getIn32_CertificationNumber() { 
        CX ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Certified By (IN3-3).
     */
    public XCN[] getCertifiedBy() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(3);  
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XCN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN3-3: "Certified By" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XCN getCertifiedBy(int rep) { 
        XCN ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN3-3: "Certified By" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XCN getIn33_CertifiedBy(int rep) { 
        XCN ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * IN3-3: "Certified By" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN insertCertifiedBy(int rep) throws HL7Exception { 
        return (XCN) super.insertRepetition(3, rep);
    }



    /**
     * Inserts a repetition of
     * IN3-3: "Certified By" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN insertIn33_CertifiedBy(int rep) throws HL7Exception { 
        return (XCN) super.insertRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * IN3-3: "Certified By" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN removeCertifiedBy(int rep) throws HL7Exception { 
        return (XCN) super.removeRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * IN3-3: "Certified By" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN removeIn33_CertifiedBy(int rep) throws HL7Exception { 
        return (XCN) super.removeRepetition(3, rep);
    }




    /**
     * Returns
     * IN3-4: "Certification Required" - creates it if necessary
     */
    public ID getCertificationRequired() { 
        ID ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN3-4: "Certification Required" - creates it if necessary
     */
    public ID getIn34_CertificationRequired() { 
        ID ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN3-5: "Penalty" - creates it if necessary
     */
    public CM_PEN getPenalty() { 
        CM_PEN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CM_PEN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN3-5: "Penalty" - creates it if necessary
     */
    public CM_PEN getIn35_Penalty() { 
        CM_PEN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CM_PEN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN3-6: "Certification Date/Time" - creates it if necessary
     */
    public TS getCertificationDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN3-6: "Certification Date/Time" - creates it if necessary
     */
    public TS getIn36_CertificationDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN3-7: "Certification Modify Date/Time" - creates it if necessary
     */
    public TS getCertificationModifyDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN3-7: "Certification Modify Date/Time" - creates it if necessary
     */
    public TS getIn37_CertificationModifyDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Operator (IN3-8).
     */
    public XCN[] getOperator() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(8);  
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XCN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN3-8: "Operator" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XCN getOperator(int rep) { 
        XCN ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN3-8: "Operator" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XCN getIn38_Operator(int rep) { 
        XCN ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * IN3-8: "Operator" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN insertOperator(int rep) throws HL7Exception { 
        return (XCN) super.insertRepetition(8, rep);
    }



    /**
     * Inserts a repetition of
     * IN3-8: "Operator" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN insertIn38_Operator(int rep) throws HL7Exception { 
        return (XCN) super.insertRepetition(8, rep);
    }


    /**
     * Removes a repetition of
     * IN3-8: "Operator" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN removeOperator(int rep) throws HL7Exception { 
        return (XCN) super.removeRepetition(8, rep);
    }


    /**
     * Removes a repetition of
     * IN3-8: "Operator" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN removeIn38_Operator(int rep) throws HL7Exception { 
        return (XCN) super.removeRepetition(8, rep);
    }




    /**
     * Returns
     * IN3-9: "Certification Begin Date" - creates it if necessary
     */
    public DT getCertificationBeginDate() { 
        DT ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN3-9: "Certification Begin Date" - creates it if necessary
     */
    public DT getIn39_CertificationBeginDate() { 
        DT ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN3-10: "Certification End Date" - creates it if necessary
     */
    public DT getCertificationEndDate() { 
        DT ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN3-10: "Certification End Date" - creates it if necessary
     */
    public DT getIn310_CertificationEndDate() { 
        DT ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN3-11: "Days" - creates it if necessary
     */
    public CM_DTN getDays() { 
        CM_DTN ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CM_DTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN3-11: "Days" - creates it if necessary
     */
    public CM_DTN getIn311_Days() { 
        CM_DTN ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CM_DTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN3-12: "Non-Concur Code/Description" - creates it if necessary
     */
    public CE getNonConcurCodeDescription() { 
        CE ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN3-12: "Non-Concur Code/Description" - creates it if necessary
     */
    public CE getIn312_NonConcurCodeDescription() { 
        CE ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN3-13: "Non-Concur Effective Date/Time" - creates it if necessary
     */
    public TS getNonConcurEffectiveDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN3-13: "Non-Concur Effective Date/Time" - creates it if necessary
     */
    public TS getIn313_NonConcurEffectiveDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Physician Reviewer (IN3-14).
     */
    public XCN[] getPhysicianReviewer() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(14);  
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XCN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN3-14: "Physician Reviewer" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XCN getPhysicianReviewer(int rep) { 
        XCN ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN3-14: "Physician Reviewer" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XCN getIn314_PhysicianReviewer(int rep) { 
        XCN ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * IN3-14: "Physician Reviewer" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN insertPhysicianReviewer(int rep) throws HL7Exception { 
        return (XCN) super.insertRepetition(14, rep);
    }



    /**
     * Inserts a repetition of
     * IN3-14: "Physician Reviewer" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN insertIn314_PhysicianReviewer(int rep) throws HL7Exception { 
        return (XCN) super.insertRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * IN3-14: "Physician Reviewer" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN removePhysicianReviewer(int rep) throws HL7Exception { 
        return (XCN) super.removeRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * IN3-14: "Physician Reviewer" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN removeIn314_PhysicianReviewer(int rep) throws HL7Exception { 
        return (XCN) super.removeRepetition(14, rep);
    }




    /**
     * Returns
     * IN3-15: "Certification Contact" - creates it if necessary
     */
    public ST getCertificationContact() { 
        ST ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN3-15: "Certification Contact" - creates it if necessary
     */
    public ST getIn315_CertificationContact() { 
        ST ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Certification Contact Phone Number (IN3-16).
     */
    public XTN[] getCertificationContactPhoneNumber() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(16);  
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XTN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN3-16: "Certification Contact Phone Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getCertificationContactPhoneNumber(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN3-16: "Certification Contact Phone Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getIn316_CertificationContactPhoneNumber(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * IN3-16: "Certification Contact Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertCertificationContactPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(16, rep);
    }



    /**
     * Inserts a repetition of
     * IN3-16: "Certification Contact Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertIn316_CertificationContactPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(16, rep);
    }


    /**
     * Removes a repetition of
     * IN3-16: "Certification Contact Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeCertificationContactPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(16, rep);
    }


    /**
     * Removes a repetition of
     * IN3-16: "Certification Contact Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeIn316_CertificationContactPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(16, rep);
    }




    /**
     * Returns
     * IN3-17: "Appeal Reason" - creates it if necessary
     */
    public CE getAppealReason() { 
        CE ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN3-17: "Appeal Reason" - creates it if necessary
     */
    public CE getIn317_AppealReason() { 
        CE ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN3-18: "Certification Agency" - creates it if necessary
     */
    public CE getCertificationAgency() { 
        CE ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN3-18: "Certification Agency" - creates it if necessary
     */
    public CE getIn318_CertificationAgency() { 
        CE ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Certification Agency Phone Number (IN3-19).
     */
    public XTN[] getCertificationAgencyPhoneNumber() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(19);  
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XTN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN3-19: "Certification Agency Phone Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getCertificationAgencyPhoneNumber(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN3-19: "Certification Agency Phone Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getIn319_CertificationAgencyPhoneNumber(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * IN3-19: "Certification Agency Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertCertificationAgencyPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(19, rep);
    }



    /**
     * Inserts a repetition of
     * IN3-19: "Certification Agency Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertIn319_CertificationAgencyPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(19, rep);
    }


    /**
     * Removes a repetition of
     * IN3-19: "Certification Agency Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeCertificationAgencyPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(19, rep);
    }


    /**
     * Removes a repetition of
     * IN3-19: "Certification Agency Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeIn319_CertificationAgencyPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(19, rep);
    }



    /**
     * Returns all repetitions of Pre-Certification required/Window (IN3-20).
     */
    public CM_PCF[] getPreCertificationRequiredWindow() {
        CM_PCF[] ret = null;
        try {
            Type[] t = this.getField(20);  
            ret = new CM_PCF[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CM_PCF)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN3-20: "Pre-Certification required/Window" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CM_PCF getPreCertificationRequiredWindow(int rep) { 
        CM_PCF ret = null;
        try {
            Type t = this.getField(20, rep);
            ret = (CM_PCF)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN3-20: "Pre-Certification required/Window" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CM_PCF getIn320_PreCertificationRequiredWindow(int rep) { 
        CM_PCF ret = null;
        try {
            Type t = this.getField(20, rep);
            ret = (CM_PCF)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * IN3-20: "Pre-Certification required/Window" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_PCF insertPreCertificationRequiredWindow(int rep) throws HL7Exception { 
        return (CM_PCF) super.insertRepetition(20, rep);
    }



    /**
     * Inserts a repetition of
     * IN3-20: "Pre-Certification required/Window" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_PCF insertIn320_PreCertificationRequiredWindow(int rep) throws HL7Exception { 
        return (CM_PCF) super.insertRepetition(20, rep);
    }


    /**
     * Removes a repetition of
     * IN3-20: "Pre-Certification required/Window" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_PCF removePreCertificationRequiredWindow(int rep) throws HL7Exception { 
        return (CM_PCF) super.removeRepetition(20, rep);
    }


    /**
     * Removes a repetition of
     * IN3-20: "Pre-Certification required/Window" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CM_PCF removeIn320_PreCertificationRequiredWindow(int rep) throws HL7Exception { 
        return (CM_PCF) super.removeRepetition(20, rep);
    }




    /**
     * Returns
     * IN3-21: "Case Manager" - creates it if necessary
     */
    public ST getCaseManager() { 
        ST ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN3-21: "Case Manager" - creates it if necessary
     */
    public ST getIn321_CaseManager() { 
        ST ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN3-22: "Second Opinion Date" - creates it if necessary
     */
    public DT getSecondOpinionDate() { 
        DT ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN3-22: "Second Opinion Date" - creates it if necessary
     */
    public DT getIn322_SecondOpinionDate() { 
        DT ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN3-23: "Second Opinion Status" - creates it if necessary
     */
    public IS getSecondOpinionStatus() { 
        IS ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN3-23: "Second Opinion Status" - creates it if necessary
     */
    public IS getIn323_SecondOpinionStatus() { 
        IS ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Second Opinion Documentation Received (IN3-24).
     */
    public IS[] getSecondOpinionDocumentationReceived() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(24);  
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (IS)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN3-24: "Second Opinion Documentation Received" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getSecondOpinionDocumentationReceived(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(24, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN3-24: "Second Opinion Documentation Received" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getIn324_SecondOpinionDocumentationReceived(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(24, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * IN3-24: "Second Opinion Documentation Received" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertSecondOpinionDocumentationReceived(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(24, rep);
    }



    /**
     * Inserts a repetition of
     * IN3-24: "Second Opinion Documentation Received" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertIn324_SecondOpinionDocumentationReceived(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(24, rep);
    }


    /**
     * Removes a repetition of
     * IN3-24: "Second Opinion Documentation Received" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removeSecondOpinionDocumentationReceived(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(24, rep);
    }


    /**
     * Removes a repetition of
     * IN3-24: "Second Opinion Documentation Received" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removeIn324_SecondOpinionDocumentationReceived(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(24, rep);
    }



    /**
     * Returns all repetitions of Second Opinion Physician (IN3-25).
     */
    public XCN[] getSecondOpinionPhysician() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(25);  
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XCN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN3-25: "Second Opinion Physician" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XCN getSecondOpinionPhysician(int rep) { 
        XCN ret = null;
        try {
            Type t = this.getField(25, rep);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN3-25: "Second Opinion Physician" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XCN getIn325_SecondOpinionPhysician(int rep) { 
        XCN ret = null;
        try {
            Type t = this.getField(25, rep);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * IN3-25: "Second Opinion Physician" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN insertSecondOpinionPhysician(int rep) throws HL7Exception { 
        return (XCN) super.insertRepetition(25, rep);
    }



    /**
     * Inserts a repetition of
     * IN3-25: "Second Opinion Physician" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN insertIn325_SecondOpinionPhysician(int rep) throws HL7Exception { 
        return (XCN) super.insertRepetition(25, rep);
    }


    /**
     * Removes a repetition of
     * IN3-25: "Second Opinion Physician" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN removeSecondOpinionPhysician(int rep) throws HL7Exception { 
        return (XCN) super.removeRepetition(25, rep);
    }


    /**
     * Removes a repetition of
     * IN3-25: "Second Opinion Physician" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN removeIn325_SecondOpinionPhysician(int rep) throws HL7Exception { 
        return (XCN) super.removeRepetition(25, rep);
    }






    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new CX(getMessage());
          case 2: return new XCN(getMessage());
          case 3: return new ID(getMessage(), new Integer( 136 ));
          case 4: return new CM_PEN(getMessage());
          case 5: return new TS(getMessage());
          case 6: return new TS(getMessage());
          case 7: return new XCN(getMessage());
          case 8: return new DT(getMessage());
          case 9: return new DT(getMessage());
          case 10: return new CM_DTN(getMessage());
          case 11: return new CE(getMessage());
          case 12: return new TS(getMessage());
          case 13: return new XCN(getMessage());
          case 14: return new ST(getMessage());
          case 15: return new XTN(getMessage());
          case 16: return new CE(getMessage());
          case 17: return new CE(getMessage());
          case 18: return new XTN(getMessage());
          case 19: return new CM_PCF(getMessage());
          case 20: return new ST(getMessage());
          case 21: return new DT(getMessage());
          case 22: return new IS(getMessage(), new Integer( 151 ));
          case 23: return new IS(getMessage(), new Integer( 152 ));
          case 24: return new XCN(getMessage());
          default: return null;
       }
   }


}

