/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.segment;

// import ca.uhn.hl7v2.model.v23.group.*;
import ca.uhn.hl7v2.model.v23.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 LCC message segment (Location Charge Code). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>LCC-1: Primary Key Value (PL) <b> </b>
     * <li>LCC-2: Location Department (IS) <b> </b>
     * <li>LCC-3: Accommodation Type (CE) <b>optional repeating</b>
     * <li>LCC-4: Charge Code (CE) <b> repeating</b>
 * </ul>
 */
public class LCC extends AbstractSegment {

    /** 
     * Creates a new LCC segment
     */
    public LCC(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(PL.class, true, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Primary Key Value");
                                  this.add(IS.class, true, 1, 10, new Object[]{ getMessage() }, "Location Department");
                                  this.add(CE.class, false, 0, 60, new Object[]{ getMessage(), new Integer(0) }, "Accommodation Type");
                                  this.add(CE.class, true, 0, 60, new Object[]{ getMessage(), new Integer(0) }, "Charge Code");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating LCC - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * LCC-1: "Primary Key Value" - creates it if necessary
     */
    public PL getPrimaryKeyValue() { 
        PL ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (PL)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * LCC-1: "Primary Key Value" - creates it if necessary
     */
    public PL getLcc1_PrimaryKeyValue() { 
        PL ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (PL)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * LCC-2: "Location Department" - creates it if necessary
     */
    public IS getLocationDepartment() { 
        IS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * LCC-2: "Location Department" - creates it if necessary
     */
    public IS getLcc2_LocationDepartment() { 
        IS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Accommodation Type (LCC-3).
     */
    public CE[] getAccommodationType() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(3);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * LCC-3: "Accommodation Type" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getAccommodationType(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * LCC-3: "Accommodation Type" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getLcc3_AccommodationType(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * LCC-3: "Accommodation Type" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertAccommodationType(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(3, rep);
    }



    /**
     * Inserts a repetition of
     * LCC-3: "Accommodation Type" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertLcc3_AccommodationType(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * LCC-3: "Accommodation Type" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeAccommodationType(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * LCC-3: "Accommodation Type" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeLcc3_AccommodationType(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(3, rep);
    }



    /**
     * Returns all repetitions of Charge Code (LCC-4).
     */
    public CE[] getChargeCode() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(4);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * LCC-4: "Charge Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getChargeCode(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * LCC-4: "Charge Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getLcc4_ChargeCode(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * LCC-4: "Charge Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertChargeCode(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(4, rep);
    }



    /**
     * Inserts a repetition of
     * LCC-4: "Charge Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertLcc4_ChargeCode(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * LCC-4: "Charge Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeChargeCode(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * LCC-4: "Charge Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeLcc4_ChargeCode(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(4, rep);
    }






    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new PL(getMessage());
          case 1: return new IS(getMessage(), new Integer( 264 ));
          case 2: return new CE(getMessage());
          case 3: return new CE(getMessage());
          default: return null;
       }
   }


}

