/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v23.segment;

// import ca.uhn.hl7v2.model.v23.group.*;
import ca.uhn.hl7v2.model.v23.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 PTH message segment (Pathway). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>PTH-1: Action Code (ID) <b> </b>
     * <li>PTH-2: Pathway ID (CE) <b> </b>
     * <li>PTH-3: Pathway Instance ID (EI) <b> </b>
     * <li>PTH-4: Pathway Established Date/Time (TS) <b> </b>
     * <li>PTH-5: Pathway Lifecycle Status (CE) <b>optional </b>
     * <li>PTH-6: Change Pathway Lifecycle Status Date/Time (TS) <b>optional </b>
 * </ul>
 */
public class PTH extends AbstractSegment {

    /** 
     * Creates a new PTH segment
     */
    public PTH(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(ID.class, true, 1, 2, new Object[]{ getMessage() }, "Action Code");
                                  this.add(CE.class, true, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Pathway ID");
                                  this.add(EI.class, true, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Pathway Instance ID");
                                  this.add(TS.class, true, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Pathway Established Date/Time");
                                  this.add(CE.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Pathway Lifecycle Status");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Change Pathway Lifecycle Status Date/Time");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PTH - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * PTH-1: "Action Code" - creates it if necessary
     */
    public ID getActionCode() { 
        ID ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PTH-1: "Action Code" - creates it if necessary
     */
    public ID getPth1_ActionCode() { 
        ID ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PTH-2: "Pathway ID" - creates it if necessary
     */
    public CE getPathwayID() { 
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PTH-2: "Pathway ID" - creates it if necessary
     */
    public CE getPth2_PathwayID() { 
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PTH-3: "Pathway Instance ID" - creates it if necessary
     */
    public EI getPathwayInstanceID() { 
        EI ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PTH-3: "Pathway Instance ID" - creates it if necessary
     */
    public EI getPth3_PathwayInstanceID() { 
        EI ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PTH-4: "Pathway Established Date/Time" - creates it if necessary
     */
    public TS getPathwayEstablishedDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PTH-4: "Pathway Established Date/Time" - creates it if necessary
     */
    public TS getPth4_PathwayEstablishedDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PTH-5: "Pathway Lifecycle Status" - creates it if necessary
     */
    public CE getPathwayLifecycleStatus() { 
        CE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PTH-5: "Pathway Lifecycle Status" - creates it if necessary
     */
    public CE getPth5_PathwayLifecycleStatus() { 
        CE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PTH-6: "Change Pathway Lifecycle Status Date/Time" - creates it if necessary
     */
    public TS getChangePathwayLifecycleStatusDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PTH-6: "Change Pathway Lifecycle Status Date/Time" - creates it if necessary
     */
    public TS getPth6_ChangePathwayLifecycleStatusDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new ID(getMessage(), new Integer( 287 ));
          case 1: return new CE(getMessage());
          case 2: return new EI(getMessage());
          case 3: return new TS(getMessage());
          case 4: return new CE(getMessage());
          case 5: return new TS(getMessage());
          default: return null;
       }
   }


}

