/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.OMN_O01_INSURANCE;
import ca.uhn.hl7v2.model.v23.group.OMN_O01_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v23.segment.AL1;
import ca.uhn.hl7v2.model.v23.segment.GT1;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.model.v23.segment.PD1;
import ca.uhn.hl7v2.model.v23.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OMN_O01_PATIENT
extends AbstractGroup {
    public OMN_O01_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(NTE.class, false, true);
            this.add(OMN_O01_PATIENT_VISIT.class, false, false);
            this.add(OMN_O01_INSURANCE.class, false, true);
            this.add(GT1.class, false, false);
            this.add(AL1.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating OMN_O01_PATIENT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PD1 getPD1() {
        PD1 ret = null;
        try {
            ret = (PD1)this.get("PD1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public OMN_O01_PATIENT_VISIT getPATIENT_VISIT() {
        OMN_O01_PATIENT_VISIT ret = null;
        try {
            ret = (OMN_O01_PATIENT_VISIT)this.get("PATIENT_VISIT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OMN_O01_INSURANCE getINSURANCE() {
        OMN_O01_INSURANCE ret = null;
        try {
            ret = (OMN_O01_INSURANCE)this.get("INSURANCE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OMN_O01_INSURANCE getINSURANCE(int rep) {
        OMN_O01_INSURANCE ret = null;
        try {
            ret = (OMN_O01_INSURANCE)this.get("INSURANCE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getINSURANCEReps() {
        int reps = -1;
        try {
            reps = this.getAll("INSURANCE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertINSURANCE(OMN_O01_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", (Structure)structure, rep);
    }

    public OMN_O01_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (OMN_O01_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public OMN_O01_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (OMN_O01_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public GT1 getGT1() {
        GT1 ret = null;
        try {
            ret = (GT1)this.get("GT1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public AL1 getAL1() {
        AL1 ret = null;
        try {
            ret = (AL1)this.get("AL1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public AL1 getAL1(int rep) {
        AL1 ret = null;
        try {
            ret = (AL1)this.get("AL1", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getAL1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("AL1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", (Structure)structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }
}

