/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.RAS_O01_ENCODING;
import ca.uhn.hl7v2.model.v23.group.RAS_O01_OBSERVATION;
import ca.uhn.hl7v2.model.v23.group.RAS_O01_ORDER_DETAIL;
import ca.uhn.hl7v2.model.v23.segment.CTI;
import ca.uhn.hl7v2.model.v23.segment.ORC;
import ca.uhn.hl7v2.model.v23.segment.RXA;
import ca.uhn.hl7v2.model.v23.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAS_O01_ORDER
extends AbstractGroup {
    public RAS_O01_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(RAS_O01_ORDER_DETAIL.class, false, false, false);
            this.add(RAS_O01_ENCODING.class, false, false, false);
            this.add(RXA.class, true, true, false);
            this.add(RXR.class, true, false, false);
            this.add(RAS_O01_OBSERVATION.class, false, true, false);
            this.add(CTI.class, false, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RAS_O01_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public RAS_O01_ORDER_DETAIL getORDER_DETAIL() {
        RAS_O01_ORDER_DETAIL retVal = (RAS_O01_ORDER_DETAIL)this.getTyped("ORDER_DETAIL", RAS_O01_ORDER_DETAIL.class);
        return retVal;
    }

    public RAS_O01_ENCODING getENCODING() {
        RAS_O01_ENCODING retVal = (RAS_O01_ENCODING)this.getTyped("ENCODING", RAS_O01_ENCODING.class);
        return retVal;
    }

    public RXA getRXA() {
        RXA retVal = (RXA)this.getTyped("RXA", RXA.class);
        return retVal;
    }

    public RXA getRXA(int rep) {
        RXA retVal = (RXA)this.getTyped("RXA", rep, RXA.class);
        return retVal;
    }

    public int getRXAReps() {
        return this.getReps("RXA");
    }

    public List<RXA> getRXAAll() throws HL7Exception {
        return this.getAllAsList("RXA", RXA.class);
    }

    public void insertRXA(RXA structure, int rep) throws HL7Exception {
        super.insertRepetition("RXA", (Structure)structure, rep);
    }

    public RXA insertRXA(int rep) throws HL7Exception {
        return (RXA)super.insertRepetition("RXA", rep);
    }

    public RXA removeRXA(int rep) throws HL7Exception {
        return (RXA)super.removeRepetition("RXA", rep);
    }

    public RXR getRXR() {
        RXR retVal = (RXR)this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public RAS_O01_OBSERVATION getOBSERVATION() {
        RAS_O01_OBSERVATION retVal = (RAS_O01_OBSERVATION)this.getTyped("OBSERVATION", RAS_O01_OBSERVATION.class);
        return retVal;
    }

    public RAS_O01_OBSERVATION getOBSERVATION(int rep) {
        RAS_O01_OBSERVATION retVal = (RAS_O01_OBSERVATION)this.getTyped("OBSERVATION", rep, RAS_O01_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<RAS_O01_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", RAS_O01_OBSERVATION.class);
    }

    public void insertOBSERVATION(RAS_O01_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public RAS_O01_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (RAS_O01_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public RAS_O01_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (RAS_O01_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public CTI getCTI() {
        CTI retVal = (CTI)this.getTyped("CTI", CTI.class);
        return retVal;
    }

    public CTI getCTI(int rep) {
        CTI retVal = (CTI)this.getTyped("CTI", rep, CTI.class);
        return retVal;
    }

    public int getCTIReps() {
        return this.getReps("CTI");
    }

    public List<CTI> getCTIAll() throws HL7Exception {
        return this.getAllAsList("CTI", CTI.class);
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", (Structure)structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }
}

