/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.ID;
import ca.uhn.hl7v2.model.v231.datatype.ST;
import ca.uhn.hl7v2.model.v231.datatype.TQ;
import ca.uhn.hl7v2.model.v231.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class URS
extends AbstractSegment {
    public URS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, true, 0, 20, new Object[]{this.getMessage()}, "R/U Where Subject Definition");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "R/U When Data Start Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "R/U When Data End Date/Time");
            this.add(ST.class, false, 0, 20, new Object[]{this.getMessage()}, "R/U What User Qualifier");
            this.add(ST.class, false, 0, 20, new Object[]{this.getMessage()}, "R/U Other Results Subject Definition");
            this.add(ID.class, false, 0, 12, new Object[]{this.getMessage(), new Integer(156)}, "R/U Which Date/Time Qualifier");
            this.add(ID.class, false, 0, 12, new Object[]{this.getMessage(), new Integer(157)}, "R/U Which Date/Time Status Qualifier");
            this.add(ID.class, false, 0, 12, new Object[]{this.getMessage(), new Integer(158)}, "R/U Date/Time Selection Qualifier");
            this.add(TQ.class, false, 1, 60, new Object[]{this.getMessage()}, "R/U Quantity/Timing Qualifier");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating URS - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST[] getRUWhereSubjectDefinition() {
        ST[] retVal = (ST[])this.getTypedField(1, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getUrs1_RUWhereSubjectDefinition() {
        ST[] retVal = (ST[])this.getTypedField(1, (Type[])new ST[0]);
        return retVal;
    }

    public int getRUWhereSubjectDefinitionReps() {
        return this.getReps(1);
    }

    public ST getRUWhereSubjectDefinition(int rep) {
        ST retVal = (ST)this.getTypedField(1, rep);
        return retVal;
    }

    public ST getUrs1_RUWhereSubjectDefinition(int rep) {
        ST retVal = (ST)this.getTypedField(1, rep);
        return retVal;
    }

    public int getUrs1_RUWhereSubjectDefinitionReps() {
        return this.getReps(1);
    }

    public ST insertRUWhereSubjectDefinition(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(1, rep);
    }

    public ST insertUrs1_RUWhereSubjectDefinition(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(1, rep);
    }

    public ST removeRUWhereSubjectDefinition(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(1, rep);
    }

    public ST removeUrs1_RUWhereSubjectDefinition(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(1, rep);
    }

    public TS getRUWhenDataStartDateTime() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getUrs2_RUWhenDataStartDateTime() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getRUWhenDataEndDateTime() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getUrs3_RUWhenDataEndDateTime() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public ST[] getRUWhatUserQualifier() {
        ST[] retVal = (ST[])this.getTypedField(4, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getUrs4_RUWhatUserQualifier() {
        ST[] retVal = (ST[])this.getTypedField(4, (Type[])new ST[0]);
        return retVal;
    }

    public int getRUWhatUserQualifierReps() {
        return this.getReps(4);
    }

    public ST getRUWhatUserQualifier(int rep) {
        ST retVal = (ST)this.getTypedField(4, rep);
        return retVal;
    }

    public ST getUrs4_RUWhatUserQualifier(int rep) {
        ST retVal = (ST)this.getTypedField(4, rep);
        return retVal;
    }

    public int getUrs4_RUWhatUserQualifierReps() {
        return this.getReps(4);
    }

    public ST insertRUWhatUserQualifier(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(4, rep);
    }

    public ST insertUrs4_RUWhatUserQualifier(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(4, rep);
    }

    public ST removeRUWhatUserQualifier(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(4, rep);
    }

    public ST removeUrs4_RUWhatUserQualifier(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(4, rep);
    }

    public ST[] getRUOtherResultsSubjectDefinition() {
        ST[] retVal = (ST[])this.getTypedField(5, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getUrs5_RUOtherResultsSubjectDefinition() {
        ST[] retVal = (ST[])this.getTypedField(5, (Type[])new ST[0]);
        return retVal;
    }

    public int getRUOtherResultsSubjectDefinitionReps() {
        return this.getReps(5);
    }

    public ST getRUOtherResultsSubjectDefinition(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public ST getUrs5_RUOtherResultsSubjectDefinition(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public int getUrs5_RUOtherResultsSubjectDefinitionReps() {
        return this.getReps(5);
    }

    public ST insertRUOtherResultsSubjectDefinition(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST insertUrs5_RUOtherResultsSubjectDefinition(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST removeRUOtherResultsSubjectDefinition(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST removeUrs5_RUOtherResultsSubjectDefinition(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ID[] getRUWhichDateTimeQualifier() {
        ID[] retVal = (ID[])this.getTypedField(6, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getUrs6_RUWhichDateTimeQualifier() {
        ID[] retVal = (ID[])this.getTypedField(6, (Type[])new ID[0]);
        return retVal;
    }

    public int getRUWhichDateTimeQualifierReps() {
        return this.getReps(6);
    }

    public ID getRUWhichDateTimeQualifier(int rep) {
        ID retVal = (ID)this.getTypedField(6, rep);
        return retVal;
    }

    public ID getUrs6_RUWhichDateTimeQualifier(int rep) {
        ID retVal = (ID)this.getTypedField(6, rep);
        return retVal;
    }

    public int getUrs6_RUWhichDateTimeQualifierReps() {
        return this.getReps(6);
    }

    public ID insertRUWhichDateTimeQualifier(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(6, rep);
    }

    public ID insertUrs6_RUWhichDateTimeQualifier(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(6, rep);
    }

    public ID removeRUWhichDateTimeQualifier(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(6, rep);
    }

    public ID removeUrs6_RUWhichDateTimeQualifier(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(6, rep);
    }

    public ID[] getRUWhichDateTimeStatusQualifier() {
        ID[] retVal = (ID[])this.getTypedField(7, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getUrs7_RUWhichDateTimeStatusQualifier() {
        ID[] retVal = (ID[])this.getTypedField(7, (Type[])new ID[0]);
        return retVal;
    }

    public int getRUWhichDateTimeStatusQualifierReps() {
        return this.getReps(7);
    }

    public ID getRUWhichDateTimeStatusQualifier(int rep) {
        ID retVal = (ID)this.getTypedField(7, rep);
        return retVal;
    }

    public ID getUrs7_RUWhichDateTimeStatusQualifier(int rep) {
        ID retVal = (ID)this.getTypedField(7, rep);
        return retVal;
    }

    public int getUrs7_RUWhichDateTimeStatusQualifierReps() {
        return this.getReps(7);
    }

    public ID insertRUWhichDateTimeStatusQualifier(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(7, rep);
    }

    public ID insertUrs7_RUWhichDateTimeStatusQualifier(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(7, rep);
    }

    public ID removeRUWhichDateTimeStatusQualifier(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(7, rep);
    }

    public ID removeUrs7_RUWhichDateTimeStatusQualifier(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(7, rep);
    }

    public ID[] getRUDateTimeSelectionQualifier() {
        ID[] retVal = (ID[])this.getTypedField(8, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getUrs8_RUDateTimeSelectionQualifier() {
        ID[] retVal = (ID[])this.getTypedField(8, (Type[])new ID[0]);
        return retVal;
    }

    public int getRUDateTimeSelectionQualifierReps() {
        return this.getReps(8);
    }

    public ID getRUDateTimeSelectionQualifier(int rep) {
        ID retVal = (ID)this.getTypedField(8, rep);
        return retVal;
    }

    public ID getUrs8_RUDateTimeSelectionQualifier(int rep) {
        ID retVal = (ID)this.getTypedField(8, rep);
        return retVal;
    }

    public int getUrs8_RUDateTimeSelectionQualifierReps() {
        return this.getReps(8);
    }

    public ID insertRUDateTimeSelectionQualifier(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(8, rep);
    }

    public ID insertUrs8_RUDateTimeSelectionQualifier(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(8, rep);
    }

    public ID removeRUDateTimeSelectionQualifier(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(8, rep);
    }

    public ID removeUrs8_RUDateTimeSelectionQualifier(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(8, rep);
    }

    public TQ getRUQuantityTimingQualifier() {
        TQ retVal = (TQ)this.getTypedField(9, 0);
        return retVal;
    }

    public TQ getUrs9_RUQuantityTimingQualifier() {
        TQ retVal = (TQ)this.getTypedField(9, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new TS(this.getMessage());
            }
            case 2: {
                return new TS(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(156));
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(157));
            }
            case 7: {
                return new ID(this.getMessage(), new Integer(158));
            }
            case 8: {
                return new TQ(this.getMessage());
            }
        }
        return null;
    }
}

