/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSuperMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.ADT_AXX_INSURANCE;
import ca.uhn.hl7v2.model.v24.group.ADT_AXX_MERGE_INFO;
import ca.uhn.hl7v2.model.v24.group.ADT_AXX_PATIENT;
import ca.uhn.hl7v2.model.v24.group.ADT_AXX_PROCEDURE;
import ca.uhn.hl7v2.model.v24.segment.ACC;
import ca.uhn.hl7v2.model.v24.segment.AL1;
import ca.uhn.hl7v2.model.v24.segment.DB1;
import ca.uhn.hl7v2.model.v24.segment.DG1;
import ca.uhn.hl7v2.model.v24.segment.DRG;
import ca.uhn.hl7v2.model.v24.segment.EVN;
import ca.uhn.hl7v2.model.v24.segment.GT1;
import ca.uhn.hl7v2.model.v24.segment.IAM;
import ca.uhn.hl7v2.model.v24.segment.MRG;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.NK1;
import ca.uhn.hl7v2.model.v24.segment.NPU;
import ca.uhn.hl7v2.model.v24.segment.OBX;
import ca.uhn.hl7v2.model.v24.segment.PD1;
import ca.uhn.hl7v2.model.v24.segment.PDA;
import ca.uhn.hl7v2.model.v24.segment.PID;
import ca.uhn.hl7v2.model.v24.segment.PV1;
import ca.uhn.hl7v2.model.v24.segment.PV2;
import ca.uhn.hl7v2.model.v24.segment.ROL;
import ca.uhn.hl7v2.model.v24.segment.UB1;
import ca.uhn.hl7v2.model.v24.segment.UB2;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADT_AXX
extends AbstractSuperMessage {
    public ADT_AXX() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public ADT_AXX(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.addSuperstructureApplication("MSH", "ADT_A04");
            this.addSuperstructureApplication("MSH", "ADT_A07");
            this.addSuperstructureApplication("MSH", "ADT_A08");
            this.addSuperstructureApplication("MSH", "ADT_A10");
            this.addSuperstructureApplication("MSH", "ADT_A11");
            this.addSuperstructureApplication("MSH", "ADT_A12");
            this.addSuperstructureApplication("MSH", "ADT_A13");
            this.addSuperstructureApplication("MSH", "ADT_A14");
            this.addSuperstructureApplication("MSH", "ADT_A22");
            this.addSuperstructureApplication("MSH", "ADT_A23");
            this.addSuperstructureApplication("MSH", "ADT_A25");
            this.addSuperstructureApplication("MSH", "ADT_A26");
            this.addSuperstructureApplication("MSH", "ADT_A27");
            this.addSuperstructureApplication("MSH", "ADT_A28");
            this.addSuperstructureApplication("MSH", "ADT_A29");
            this.addSuperstructureApplication("MSH", "ADT_A31");
            this.addSuperstructureApplication("MSH", "ADT_A32");
            this.addSuperstructureApplication("MSH", "ADT_A33");
            this.addSuperstructureApplication("MSH", "ADT_A34");
            this.addSuperstructureApplication("MSH", "ADT_A35");
            this.addSuperstructureApplication("MSH", "ADT_A36");
            this.addSuperstructureApplication("MSH", "ADT_A40");
            this.addSuperstructureApplication("MSH", "ADT_A41");
            this.addSuperstructureApplication("MSH", "ADT_A42");
            this.addSuperstructureApplication("MSH", "ADT_A44");
            this.addSuperstructureApplication("MSH", "ADT_A46");
            this.addSuperstructureApplication("MSH", "ADT_A47");
            this.addSuperstructureApplication("MSH", "ADT_A48");
            this.addSuperstructureApplication("MSH", "ADT_A49");
            this.addSuperstructureApplication("MSH", "ADT_A51");
            this.addSuperstructureApplication("MSH", "ADT_A53");
            this.addSuperstructureApplication("MSH", "ADT_A55");
            this.addSuperstructureApplication("MSH", "ADT_A62");
            this.add(EVN.class, true, false);
            this.addSuperstructureApplication("EVN", "ADT_A04");
            this.addSuperstructureApplication("EVN", "ADT_A07");
            this.addSuperstructureApplication("EVN", "ADT_A08");
            this.addSuperstructureApplication("EVN", "ADT_A10");
            this.addSuperstructureApplication("EVN", "ADT_A11");
            this.addSuperstructureApplication("EVN", "ADT_A12");
            this.addSuperstructureApplication("EVN", "ADT_A13");
            this.addSuperstructureApplication("EVN", "ADT_A14");
            this.addSuperstructureApplication("EVN", "ADT_A22");
            this.addSuperstructureApplication("EVN", "ADT_A23");
            this.addSuperstructureApplication("EVN", "ADT_A25");
            this.addSuperstructureApplication("EVN", "ADT_A26");
            this.addSuperstructureApplication("EVN", "ADT_A27");
            this.addSuperstructureApplication("EVN", "ADT_A28");
            this.addSuperstructureApplication("EVN", "ADT_A29");
            this.addSuperstructureApplication("EVN", "ADT_A31");
            this.addSuperstructureApplication("EVN", "ADT_A32");
            this.addSuperstructureApplication("EVN", "ADT_A33");
            this.addSuperstructureApplication("EVN", "ADT_A34");
            this.addSuperstructureApplication("EVN", "ADT_A35");
            this.addSuperstructureApplication("EVN", "ADT_A36");
            this.addSuperstructureApplication("EVN", "ADT_A40");
            this.addSuperstructureApplication("EVN", "ADT_A41");
            this.addSuperstructureApplication("EVN", "ADT_A42");
            this.addSuperstructureApplication("EVN", "ADT_A44");
            this.addSuperstructureApplication("EVN", "ADT_A46");
            this.addSuperstructureApplication("EVN", "ADT_A47");
            this.addSuperstructureApplication("EVN", "ADT_A48");
            this.addSuperstructureApplication("EVN", "ADT_A49");
            this.addSuperstructureApplication("EVN", "ADT_A51");
            this.addSuperstructureApplication("EVN", "ADT_A53");
            this.addSuperstructureApplication("EVN", "ADT_A55");
            this.addSuperstructureApplication("EVN", "ADT_A62");
            this.add(PID.class, false, false);
            this.addSuperstructureApplication("PID", "ADT_A04");
            this.addSuperstructureApplication("PID", "ADT_A07");
            this.addSuperstructureApplication("PID", "ADT_A08");
            this.addSuperstructureApplication("PID", "ADT_A10");
            this.addSuperstructureApplication("PID", "ADT_A11");
            this.addSuperstructureApplication("PID", "ADT_A12");
            this.addSuperstructureApplication("PID", "ADT_A13");
            this.addSuperstructureApplication("PID", "ADT_A14");
            this.addSuperstructureApplication("PID", "ADT_A22");
            this.addSuperstructureApplication("PID", "ADT_A23");
            this.addSuperstructureApplication("PID", "ADT_A25");
            this.addSuperstructureApplication("PID", "ADT_A26");
            this.addSuperstructureApplication("PID", "ADT_A27");
            this.addSuperstructureApplication("PID", "ADT_A28");
            this.addSuperstructureApplication("PID", "ADT_A29");
            this.addSuperstructureApplication("PID", "ADT_A31");
            this.addSuperstructureApplication("PID", "ADT_A32");
            this.addSuperstructureApplication("PID", "ADT_A33");
            this.addSuperstructureApplication("PID", "ADT_A34");
            this.addSuperstructureApplication("PID", "ADT_A35");
            this.addSuperstructureApplication("PID", "ADT_A36");
            this.addSuperstructureApplication("PID", "ADT_A46");
            this.addSuperstructureApplication("PID", "ADT_A47");
            this.addSuperstructureApplication("PID", "ADT_A48");
            this.addSuperstructureApplication("PID", "ADT_A49");
            this.addSuperstructureApplication("PID", "ADT_A51");
            this.addSuperstructureApplication("PID", "ADT_A53");
            this.addSuperstructureApplication("PID", "ADT_A55");
            this.addSuperstructureApplication("PID", "ADT_A62");
            this.add(PD1.class, false, false);
            this.addSuperstructureApplication("PD1", "ADT_A04");
            this.addSuperstructureApplication("PD1", "ADT_A07");
            this.addSuperstructureApplication("PD1", "ADT_A08");
            this.addSuperstructureApplication("PD1", "ADT_A10");
            this.addSuperstructureApplication("PD1", "ADT_A11");
            this.addSuperstructureApplication("PD1", "ADT_A12");
            this.addSuperstructureApplication("PD1", "ADT_A13");
            this.addSuperstructureApplication("PD1", "ADT_A14");
            this.addSuperstructureApplication("PD1", "ADT_A22");
            this.addSuperstructureApplication("PD1", "ADT_A23");
            this.addSuperstructureApplication("PD1", "ADT_A25");
            this.addSuperstructureApplication("PD1", "ADT_A26");
            this.addSuperstructureApplication("PD1", "ADT_A27");
            this.addSuperstructureApplication("PD1", "ADT_A28");
            this.addSuperstructureApplication("PD1", "ADT_A29");
            this.addSuperstructureApplication("PD1", "ADT_A31");
            this.addSuperstructureApplication("PD1", "ADT_A32");
            this.addSuperstructureApplication("PD1", "ADT_A33");
            this.addSuperstructureApplication("PD1", "ADT_A34");
            this.addSuperstructureApplication("PD1", "ADT_A35");
            this.addSuperstructureApplication("PD1", "ADT_A36");
            this.addSuperstructureApplication("PD1", "ADT_A46");
            this.addSuperstructureApplication("PD1", "ADT_A47");
            this.addSuperstructureApplication("PD1", "ADT_A48");
            this.addSuperstructureApplication("PD1", "ADT_A49");
            this.addSuperstructureApplication("PD1", "ADT_A51");
            this.addSuperstructureApplication("PD1", "ADT_A53");
            this.addSuperstructureApplication("PD1", "ADT_A55");
            this.addSuperstructureApplication("PD1", "ADT_A62");
            this.add(ROL.class, false, true);
            this.addSuperstructureApplication("ROL", "ADT_A04");
            this.addSuperstructureApplication("ROL", "ADT_A07");
            this.addSuperstructureApplication("ROL", "ADT_A08");
            this.addSuperstructureApplication("ROL", "ADT_A13");
            this.addSuperstructureApplication("ROL", "ADT_A14");
            this.addSuperstructureApplication("ROL", "ADT_A28");
            this.addSuperstructureApplication("ROL", "ADT_A31");
            this.addSuperstructureApplication("ROL", "ADT_A62");
            this.add(MRG.class, false, false);
            this.addSuperstructureApplication("MRG", "ADT_A07");
            this.addSuperstructureApplication("MRG", "ADT_A34");
            this.addSuperstructureApplication("MRG", "ADT_A35");
            this.addSuperstructureApplication("MRG", "ADT_A36");
            this.addSuperstructureApplication("MRG", "ADT_A46");
            this.addSuperstructureApplication("MRG", "ADT_A47");
            this.addSuperstructureApplication("MRG", "ADT_A48");
            this.addSuperstructureApplication("MRG", "ADT_A49");
            this.addSuperstructureApplication("MRG", "ADT_A51");
            this.add(NK1.class, false, true);
            this.addSuperstructureApplication("NK1", "ADT_A04");
            this.addSuperstructureApplication("NK1", "ADT_A07");
            this.addSuperstructureApplication("NK1", "ADT_A08");
            this.addSuperstructureApplication("NK1", "ADT_A13");
            this.addSuperstructureApplication("NK1", "ADT_A14");
            this.addSuperstructureApplication("NK1", "ADT_A28");
            this.addSuperstructureApplication("NK1", "ADT_A31");
            this.add(PV1.class, false, false);
            this.addSuperstructureApplication("PV1", "ADT_A04");
            this.addSuperstructureApplication("PV1", "ADT_A07");
            this.addSuperstructureApplication("PV1", "ADT_A08");
            this.addSuperstructureApplication("PV1", "ADT_A10");
            this.addSuperstructureApplication("PV1", "ADT_A11");
            this.addSuperstructureApplication("PV1", "ADT_A12");
            this.addSuperstructureApplication("PV1", "ADT_A13");
            this.addSuperstructureApplication("PV1", "ADT_A14");
            this.addSuperstructureApplication("PV1", "ADT_A22");
            this.addSuperstructureApplication("PV1", "ADT_A23");
            this.addSuperstructureApplication("PV1", "ADT_A25");
            this.addSuperstructureApplication("PV1", "ADT_A26");
            this.addSuperstructureApplication("PV1", "ADT_A27");
            this.addSuperstructureApplication("PV1", "ADT_A28");
            this.addSuperstructureApplication("PV1", "ADT_A29");
            this.addSuperstructureApplication("PV1", "ADT_A31");
            this.addSuperstructureApplication("PV1", "ADT_A32");
            this.addSuperstructureApplication("PV1", "ADT_A33");
            this.addSuperstructureApplication("PV1", "ADT_A51");
            this.addSuperstructureApplication("PV1", "ADT_A53");
            this.addSuperstructureApplication("PV1", "ADT_A55");
            this.addSuperstructureApplication("PV1", "ADT_A62");
            this.add(PV2.class, false, false);
            this.addSuperstructureApplication("PV2", "ADT_A04");
            this.addSuperstructureApplication("PV2", "ADT_A07");
            this.addSuperstructureApplication("PV2", "ADT_A08");
            this.addSuperstructureApplication("PV2", "ADT_A10");
            this.addSuperstructureApplication("PV2", "ADT_A11");
            this.addSuperstructureApplication("PV2", "ADT_A12");
            this.addSuperstructureApplication("PV2", "ADT_A13");
            this.addSuperstructureApplication("PV2", "ADT_A14");
            this.addSuperstructureApplication("PV2", "ADT_A22");
            this.addSuperstructureApplication("PV2", "ADT_A23");
            this.addSuperstructureApplication("PV2", "ADT_A25");
            this.addSuperstructureApplication("PV2", "ADT_A26");
            this.addSuperstructureApplication("PV2", "ADT_A27");
            this.addSuperstructureApplication("PV2", "ADT_A28");
            this.addSuperstructureApplication("PV2", "ADT_A29");
            this.addSuperstructureApplication("PV2", "ADT_A31");
            this.addSuperstructureApplication("PV2", "ADT_A32");
            this.addSuperstructureApplication("PV2", "ADT_A33");
            this.addSuperstructureApplication("PV2", "ADT_A53");
            this.addSuperstructureApplication("PV2", "ADT_A55");
            this.addSuperstructureApplication("PV2", "ADT_A62");
            this.add(ROL.class, false, true);
            this.addSuperstructureApplication("ROL2", "ADT_A04");
            this.addSuperstructureApplication("ROL2", "ADT_A07");
            this.addSuperstructureApplication("ROL2", "ADT_A08");
            this.addSuperstructureApplication("ROL2", "ADT_A13");
            this.addSuperstructureApplication("ROL2", "ADT_A14");
            this.addSuperstructureApplication("ROL2", "ADT_A28");
            this.addSuperstructureApplication("ROL2", "ADT_A31");
            this.add(DB1.class, false, true);
            this.addSuperstructureApplication("DB1", "ADT_A04");
            this.addSuperstructureApplication("DB1", "ADT_A07");
            this.addSuperstructureApplication("DB1", "ADT_A08");
            this.addSuperstructureApplication("DB1", "ADT_A10");
            this.addSuperstructureApplication("DB1", "ADT_A11");
            this.addSuperstructureApplication("DB1", "ADT_A12");
            this.addSuperstructureApplication("DB1", "ADT_A13");
            this.addSuperstructureApplication("DB1", "ADT_A14");
            this.addSuperstructureApplication("DB1", "ADT_A22");
            this.addSuperstructureApplication("DB1", "ADT_A23");
            this.addSuperstructureApplication("DB1", "ADT_A25");
            this.addSuperstructureApplication("DB1", "ADT_A26");
            this.addSuperstructureApplication("DB1", "ADT_A27");
            this.addSuperstructureApplication("DB1", "ADT_A28");
            this.addSuperstructureApplication("DB1", "ADT_A29");
            this.addSuperstructureApplication("DB1", "ADT_A31");
            this.addSuperstructureApplication("DB1", "ADT_A32");
            this.addSuperstructureApplication("DB1", "ADT_A33");
            this.add(OBX.class, false, true);
            this.addSuperstructureApplication("OBX", "ADT_A04");
            this.addSuperstructureApplication("OBX", "ADT_A07");
            this.addSuperstructureApplication("OBX", "ADT_A08");
            this.addSuperstructureApplication("OBX", "ADT_A10");
            this.addSuperstructureApplication("OBX", "ADT_A11");
            this.addSuperstructureApplication("OBX", "ADT_A12");
            this.addSuperstructureApplication("OBX", "ADT_A13");
            this.addSuperstructureApplication("OBX", "ADT_A14");
            this.addSuperstructureApplication("OBX", "ADT_A22");
            this.addSuperstructureApplication("OBX", "ADT_A23");
            this.addSuperstructureApplication("OBX", "ADT_A25");
            this.addSuperstructureApplication("OBX", "ADT_A26");
            this.addSuperstructureApplication("OBX", "ADT_A27");
            this.addSuperstructureApplication("OBX", "ADT_A28");
            this.addSuperstructureApplication("OBX", "ADT_A29");
            this.addSuperstructureApplication("OBX", "ADT_A31");
            this.addSuperstructureApplication("OBX", "ADT_A32");
            this.addSuperstructureApplication("OBX", "ADT_A33");
            this.add(AL1.class, false, true);
            this.addSuperstructureApplication("AL1", "ADT_A04");
            this.addSuperstructureApplication("AL1", "ADT_A07");
            this.addSuperstructureApplication("AL1", "ADT_A08");
            this.addSuperstructureApplication("AL1", "ADT_A13");
            this.addSuperstructureApplication("AL1", "ADT_A14");
            this.addSuperstructureApplication("AL1", "ADT_A28");
            this.addSuperstructureApplication("AL1", "ADT_A31");
            this.add(DG1.class, false, true);
            this.addSuperstructureApplication("DG1", "ADT_A04");
            this.addSuperstructureApplication("DG1", "ADT_A07");
            this.addSuperstructureApplication("DG1", "ADT_A08");
            this.addSuperstructureApplication("DG1", "ADT_A10");
            this.addSuperstructureApplication("DG1", "ADT_A11");
            this.addSuperstructureApplication("DG1", "ADT_A12");
            this.addSuperstructureApplication("DG1", "ADT_A13");
            this.addSuperstructureApplication("DG1", "ADT_A14");
            this.addSuperstructureApplication("DG1", "ADT_A28");
            this.addSuperstructureApplication("DG1", "ADT_A31");
            this.add(DRG.class, false, false);
            this.addSuperstructureApplication("DRG", "ADT_A04");
            this.addSuperstructureApplication("DRG", "ADT_A07");
            this.addSuperstructureApplication("DRG", "ADT_A08");
            this.addSuperstructureApplication("DRG", "ADT_A13");
            this.addSuperstructureApplication("DRG", "ADT_A14");
            this.addSuperstructureApplication("DRG", "ADT_A28");
            this.addSuperstructureApplication("DRG", "ADT_A31");
            this.add(ADT_AXX_PROCEDURE.class, false, true);
            this.addSuperstructureApplication("PROCEDURE", "ADT_A13");
            this.addSuperstructureApplication("PROCEDURE", "ADT_A04");
            this.addSuperstructureApplication("PROCEDURE", "ADT_A08");
            this.addSuperstructureApplication("PROCEDURE", "ADT_A14");
            this.addSuperstructureApplication("PROCEDURE", "ADT_A31");
            this.addSuperstructureApplication("PROCEDURE", "ADT_A28");
            this.addSuperstructureApplication("PROCEDURE", "ADT_A07");
            this.add(GT1.class, false, true);
            this.addSuperstructureApplication("GT1", "ADT_A04");
            this.addSuperstructureApplication("GT1", "ADT_A07");
            this.addSuperstructureApplication("GT1", "ADT_A08");
            this.addSuperstructureApplication("GT1", "ADT_A13");
            this.addSuperstructureApplication("GT1", "ADT_A14");
            this.addSuperstructureApplication("GT1", "ADT_A28");
            this.addSuperstructureApplication("GT1", "ADT_A31");
            this.add(ADT_AXX_INSURANCE.class, false, true);
            this.addSuperstructureApplication("INSURANCE", "ADT_A13");
            this.addSuperstructureApplication("INSURANCE", "ADT_A04");
            this.addSuperstructureApplication("INSURANCE", "ADT_A08");
            this.addSuperstructureApplication("INSURANCE", "ADT_A14");
            this.addSuperstructureApplication("INSURANCE", "ADT_A31");
            this.addSuperstructureApplication("INSURANCE", "ADT_A28");
            this.addSuperstructureApplication("INSURANCE", "ADT_A07");
            this.add(ACC.class, false, false);
            this.addSuperstructureApplication("ACC", "ADT_A04");
            this.addSuperstructureApplication("ACC", "ADT_A07");
            this.addSuperstructureApplication("ACC", "ADT_A08");
            this.addSuperstructureApplication("ACC", "ADT_A13");
            this.addSuperstructureApplication("ACC", "ADT_A14");
            this.addSuperstructureApplication("ACC", "ADT_A28");
            this.addSuperstructureApplication("ACC", "ADT_A31");
            this.add(UB1.class, false, false);
            this.addSuperstructureApplication("UB1", "ADT_A04");
            this.addSuperstructureApplication("UB1", "ADT_A07");
            this.addSuperstructureApplication("UB1", "ADT_A08");
            this.addSuperstructureApplication("UB1", "ADT_A13");
            this.addSuperstructureApplication("UB1", "ADT_A14");
            this.addSuperstructureApplication("UB1", "ADT_A28");
            this.addSuperstructureApplication("UB1", "ADT_A31");
            this.add(UB2.class, false, false);
            this.addSuperstructureApplication("UB2", "ADT_A04");
            this.addSuperstructureApplication("UB2", "ADT_A07");
            this.addSuperstructureApplication("UB2", "ADT_A08");
            this.addSuperstructureApplication("UB2", "ADT_A13");
            this.addSuperstructureApplication("UB2", "ADT_A14");
            this.addSuperstructureApplication("UB2", "ADT_A28");
            this.addSuperstructureApplication("UB2", "ADT_A31");
            this.add(PDA.class, false, false);
            this.addSuperstructureApplication("PDA", "ADT_A04");
            this.addSuperstructureApplication("PDA", "ADT_A08");
            this.addSuperstructureApplication("PDA", "ADT_A13");
            this.add(PID.class, false, false);
            this.add(PD1.class, false, false);
            this.add(PV1.class, false, false);
            this.add(PV2.class, false, false);
            this.add(DB1.class, false, true);
            this.add(OBX.class, false, true);
            this.add(NPU.class, false, false);
            this.add(ADT_AXX_PATIENT.class, false, true);
            this.addSuperstructureApplication("PATIENT", "ADT_A42");
            this.addSuperstructureApplication("PATIENT", "ADT_A41");
            this.addSuperstructureApplication("PATIENT", "ADT_A40");
            this.addSuperstructureApplication("PATIENT", "ADT_A44");
            this.add(ADT_AXX_MERGE_INFO.class, false, true);
            this.add(IAM.class, false, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ADT_AXX - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public List<String> getChildNamesForStructure(String theStructure) {
        ArrayList<String> retVal = new ArrayList<String>();
        if ("ADT_A01".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("ROL");
            retVal.add("NK1");
            retVal.add("PV1");
            retVal.add("PV2");
            retVal.add("ROL2");
            retVal.add("DB1");
            retVal.add("OBX");
            retVal.add("AL1");
            retVal.add("DG1");
            retVal.add("DRG");
            retVal.add("PROCEDURE");
            retVal.add("GT1");
            retVal.add("INSURANCE");
            retVal.add("ACC");
            retVal.add("UB1");
            retVal.add("UB2");
            retVal.add("PDA");
        }
        if ("ADT_A02".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("ROL");
            retVal.add("PV1");
            retVal.add("PV2");
            retVal.add("ROL2");
            retVal.add("DB1");
            retVal.add("OBX");
            retVal.add("PDA");
        }
        if ("ADT_A03".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("ROL");
            retVal.add("PV1");
            retVal.add("PV2");
            retVal.add("ROL2");
            retVal.add("DB1");
            retVal.add("DG1");
            retVal.add("DRG");
            retVal.add("PROCEDURE");
            retVal.add("OBX");
            retVal.add("PDA");
        }
        if ("ADT_A05".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("ROL");
            retVal.add("NK1");
            retVal.add("PV1");
            retVal.add("PV2");
            retVal.add("ROL2");
            retVal.add("DB1");
            retVal.add("OBX");
            retVal.add("AL1");
            retVal.add("DG1");
            retVal.add("DRG");
            retVal.add("PROCEDURE");
            retVal.add("GT1");
            retVal.add("INSURANCE");
            retVal.add("ACC");
            retVal.add("UB1");
            retVal.add("UB2");
        }
        if ("ADT_A06".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("ROL");
            retVal.add("MRG");
            retVal.add("NK1");
            retVal.add("PV1");
            retVal.add("PV2");
            retVal.add("ROL2");
            retVal.add("DB1");
            retVal.add("OBX");
            retVal.add("AL1");
            retVal.add("DG1");
            retVal.add("DRG");
            retVal.add("PROCEDURE");
            retVal.add("GT1");
            retVal.add("INSURANCE");
            retVal.add("ACC");
            retVal.add("UB1");
            retVal.add("UB2");
        }
        if ("ADT_A09".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("PV1");
            retVal.add("PV2");
            retVal.add("DB1");
            retVal.add("OBX");
            retVal.add("DG1");
        }
        if ("ADT_A15".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("ROL");
            retVal.add("PV1");
            retVal.add("PV2");
            retVal.add("ROL2");
            retVal.add("DB1");
            retVal.add("OBX");
            retVal.add("DG1");
        }
        if ("ADT_A16".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("ROL");
            retVal.add("PV1");
            retVal.add("PV2");
            retVal.add("ROL2");
            retVal.add("DB1");
            retVal.add("OBX");
            retVal.add("DG1");
            retVal.add("DRG");
        }
        if ("ADT_A17".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("PV1");
            retVal.add("PV2");
            retVal.add("DB1");
            retVal.add("OBX");
            retVal.add("PID2");
            retVal.add("PD12");
            retVal.add("PV12");
            retVal.add("PV22");
            retVal.add("DB12");
            retVal.add("OBX2");
        }
        if ("ADT_A18".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("MRG");
            retVal.add("PV1");
        }
        if ("ADT_A20".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("NPU");
        }
        if ("ADT_A21".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("PV1");
            retVal.add("PV2");
            retVal.add("DB1");
            retVal.add("OBX");
        }
        if ("ADT_A24".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("PV1");
            retVal.add("DB1");
            retVal.add("PID2");
            retVal.add("PD12");
            retVal.add("PV12");
            retVal.add("DB12");
        }
        if ("ADT_A30".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("MRG");
        }
        if ("ADT_A37".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("PV1");
            retVal.add("DB1");
            retVal.add("PID2");
            retVal.add("PD12");
            retVal.add("PV12");
            retVal.add("DB12");
        }
        if ("ADT_A38".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("PV1");
            retVal.add("PV2");
            retVal.add("DB1");
            retVal.add("OBX");
            retVal.add("DG1");
            retVal.add("DRG");
        }
        if ("ADT_A39".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PATIENT");
        }
        if ("ADT_A43".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PATIENT");
        }
        if ("ADT_A45".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("MERGE_INFO");
        }
        if ("ADT_A50".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("MRG");
            retVal.add("PV1");
        }
        if ("ADT_A52".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("PV1");
            retVal.add("PV2");
        }
        if ("ADT_A54".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("ROL");
            retVal.add("PV1");
            retVal.add("PV2");
            retVal.add("ROL2");
        }
        if ("ADT_A60".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PV1");
            retVal.add("PV2");
            retVal.add("IAM");
        }
        if ("ADT_A61".equals(theStructure)) {
            retVal.add("MSH");
            retVal.add("EVN");
            retVal.add("PID");
            retVal.add("PD1");
            retVal.add("PV1");
            retVal.add("ROL");
            retVal.add("PV2");
        }
        return retVal;
    }

    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public EVN getEVN() {
        return (EVN)this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return (PID)this.getTyped("PID", PID.class);
    }

    public PD1 getPD1() {
        return (PD1)this.getTyped("PD1", PD1.class);
    }

    public ROL getROL() {
        return (ROL)this.getTyped("ROL", ROL.class);
    }

    public ROL getROL(int rep) {
        return (ROL)this.getTyped("ROL", rep, ROL.class);
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", (Structure)structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public MRG getMRG() {
        return (MRG)this.getTyped("MRG", MRG.class);
    }

    public NK1 getNK1() {
        return (NK1)this.getTyped("NK1", NK1.class);
    }

    public NK1 getNK1(int rep) {
        return (NK1)this.getTyped("NK1", rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", (Structure)structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public PV1 getPV1() {
        return (PV1)this.getTyped("PV1", PV1.class);
    }

    public PV2 getPV2() {
        return (PV2)this.getTyped("PV2", PV2.class);
    }

    public ROL getROL2() {
        return (ROL)this.getTyped("ROL2", ROL.class);
    }

    public ROL getROL2(int rep) {
        return (ROL)this.getTyped("ROL2", rep, ROL.class);
    }

    public int getROL2Reps() {
        return this.getReps("ROL2");
    }

    public List<ROL> getROL2All() throws HL7Exception {
        return this.getAllAsList("ROL2", ROL.class);
    }

    public void insertROL2(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL2", (Structure)structure, rep);
    }

    public ROL insertROL2(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL2", rep);
    }

    public ROL removeROL2(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL2", rep);
    }

    public DB1 getDB1() {
        return (DB1)this.getTyped("DB1", DB1.class);
    }

    public DB1 getDB1(int rep) {
        return (DB1)this.getTyped("DB1", rep, DB1.class);
    }

    public int getDB1Reps() {
        return this.getReps("DB1");
    }

    public List<DB1> getDB1All() throws HL7Exception {
        return this.getAllAsList("DB1", DB1.class);
    }

    public void insertDB1(DB1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DB1", (Structure)structure, rep);
    }

    public DB1 insertDB1(int rep) throws HL7Exception {
        return (DB1)super.insertRepetition("DB1", rep);
    }

    public DB1 removeDB1(int rep) throws HL7Exception {
        return (DB1)super.removeRepetition("DB1", rep);
    }

    public OBX getOBX() {
        return (OBX)this.getTyped("OBX", OBX.class);
    }

    public OBX getOBX(int rep) {
        return (OBX)this.getTyped("OBX", rep, OBX.class);
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", (Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public AL1 getAL1() {
        return (AL1)this.getTyped("AL1", AL1.class);
    }

    public AL1 getAL1(int rep) {
        return (AL1)this.getTyped("AL1", rep, AL1.class);
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", (Structure)structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }

    public DG1 getDG1() {
        return (DG1)this.getTyped("DG1", DG1.class);
    }

    public DG1 getDG1(int rep) {
        return (DG1)this.getTyped("DG1", rep, DG1.class);
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", (Structure)structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public DRG getDRG() {
        return (DRG)this.getTyped("DRG", DRG.class);
    }

    public ADT_AXX_PROCEDURE getPROCEDURE() {
        return (ADT_AXX_PROCEDURE)this.getTyped("PROCEDURE", ADT_AXX_PROCEDURE.class);
    }

    public ADT_AXX_PROCEDURE getPROCEDURE(int rep) {
        return (ADT_AXX_PROCEDURE)this.getTyped("PROCEDURE", rep, ADT_AXX_PROCEDURE.class);
    }

    public int getPROCEDUREReps() {
        return this.getReps("PROCEDURE");
    }

    public List<ADT_AXX_PROCEDURE> getPROCEDUREAll() throws HL7Exception {
        return this.getAllAsList("PROCEDURE", ADT_AXX_PROCEDURE.class);
    }

    public void insertPROCEDURE(ADT_AXX_PROCEDURE structure, int rep) throws HL7Exception {
        super.insertRepetition("PROCEDURE", (Structure)structure, rep);
    }

    public ADT_AXX_PROCEDURE insertPROCEDURE(int rep) throws HL7Exception {
        return (ADT_AXX_PROCEDURE)super.insertRepetition("PROCEDURE", rep);
    }

    public ADT_AXX_PROCEDURE removePROCEDURE(int rep) throws HL7Exception {
        return (ADT_AXX_PROCEDURE)super.removeRepetition("PROCEDURE", rep);
    }

    public GT1 getGT1() {
        return (GT1)this.getTyped("GT1", GT1.class);
    }

    public GT1 getGT1(int rep) {
        return (GT1)this.getTyped("GT1", rep, GT1.class);
    }

    public int getGT1Reps() {
        return this.getReps("GT1");
    }

    public List<GT1> getGT1All() throws HL7Exception {
        return this.getAllAsList("GT1", GT1.class);
    }

    public void insertGT1(GT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("GT1", (Structure)structure, rep);
    }

    public GT1 insertGT1(int rep) throws HL7Exception {
        return (GT1)super.insertRepetition("GT1", rep);
    }

    public GT1 removeGT1(int rep) throws HL7Exception {
        return (GT1)super.removeRepetition("GT1", rep);
    }

    public ADT_AXX_INSURANCE getINSURANCE() {
        return (ADT_AXX_INSURANCE)this.getTyped("INSURANCE", ADT_AXX_INSURANCE.class);
    }

    public ADT_AXX_INSURANCE getINSURANCE(int rep) {
        return (ADT_AXX_INSURANCE)this.getTyped("INSURANCE", rep, ADT_AXX_INSURANCE.class);
    }

    public int getINSURANCEReps() {
        return this.getReps("INSURANCE");
    }

    public List<ADT_AXX_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", ADT_AXX_INSURANCE.class);
    }

    public void insertINSURANCE(ADT_AXX_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", (Structure)structure, rep);
    }

    public ADT_AXX_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (ADT_AXX_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public ADT_AXX_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (ADT_AXX_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public ACC getACC() {
        return (ACC)this.getTyped("ACC", ACC.class);
    }

    public UB1 getUB1() {
        return (UB1)this.getTyped("UB1", UB1.class);
    }

    public UB2 getUB2() {
        return (UB2)this.getTyped("UB2", UB2.class);
    }

    public PDA getPDA() {
        return (PDA)this.getTyped("PDA", PDA.class);
    }

    public PID getPID2() {
        return (PID)this.getTyped("PID2", PID.class);
    }

    public PD1 getPD12() {
        return (PD1)this.getTyped("PD12", PD1.class);
    }

    public PV1 getPV12() {
        return (PV1)this.getTyped("PV12", PV1.class);
    }

    public PV2 getPV22() {
        return (PV2)this.getTyped("PV22", PV2.class);
    }

    public DB1 getDB12() {
        return (DB1)this.getTyped("DB12", DB1.class);
    }

    public DB1 getDB12(int rep) {
        return (DB1)this.getTyped("DB12", rep, DB1.class);
    }

    public int getDB12Reps() {
        return this.getReps("DB12");
    }

    public List<DB1> getDB12All() throws HL7Exception {
        return this.getAllAsList("DB12", DB1.class);
    }

    public void insertDB12(DB1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DB12", (Structure)structure, rep);
    }

    public DB1 insertDB12(int rep) throws HL7Exception {
        return (DB1)super.insertRepetition("DB12", rep);
    }

    public DB1 removeDB12(int rep) throws HL7Exception {
        return (DB1)super.removeRepetition("DB12", rep);
    }

    public OBX getOBX2() {
        return (OBX)this.getTyped("OBX2", OBX.class);
    }

    public OBX getOBX2(int rep) {
        return (OBX)this.getTyped("OBX2", rep, OBX.class);
    }

    public int getOBX2Reps() {
        return this.getReps("OBX2");
    }

    public List<OBX> getOBX2All() throws HL7Exception {
        return this.getAllAsList("OBX2", OBX.class);
    }

    public void insertOBX2(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX2", (Structure)structure, rep);
    }

    public OBX insertOBX2(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX2", rep);
    }

    public OBX removeOBX2(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX2", rep);
    }

    public NPU getNPU() {
        return (NPU)this.getTyped("NPU", NPU.class);
    }

    public ADT_AXX_PATIENT getPATIENT() {
        return (ADT_AXX_PATIENT)this.getTyped("PATIENT", ADT_AXX_PATIENT.class);
    }

    public ADT_AXX_PATIENT getPATIENT(int rep) {
        return (ADT_AXX_PATIENT)this.getTyped("PATIENT", rep, ADT_AXX_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<ADT_AXX_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", ADT_AXX_PATIENT.class);
    }

    public void insertPATIENT(ADT_AXX_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", (Structure)structure, rep);
    }

    public ADT_AXX_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (ADT_AXX_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public ADT_AXX_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (ADT_AXX_PATIENT)super.removeRepetition("PATIENT", rep);
    }

    public ADT_AXX_MERGE_INFO getMERGE_INFO() {
        return (ADT_AXX_MERGE_INFO)this.getTyped("MERGE_INFO", ADT_AXX_MERGE_INFO.class);
    }

    public ADT_AXX_MERGE_INFO getMERGE_INFO(int rep) {
        return (ADT_AXX_MERGE_INFO)this.getTyped("MERGE_INFO", rep, ADT_AXX_MERGE_INFO.class);
    }

    public int getMERGE_INFOReps() {
        return this.getReps("MERGE_INFO");
    }

    public List<ADT_AXX_MERGE_INFO> getMERGE_INFOAll() throws HL7Exception {
        return this.getAllAsList("MERGE_INFO", ADT_AXX_MERGE_INFO.class);
    }

    public void insertMERGE_INFO(ADT_AXX_MERGE_INFO structure, int rep) throws HL7Exception {
        super.insertRepetition("MERGE_INFO", (Structure)structure, rep);
    }

    public ADT_AXX_MERGE_INFO insertMERGE_INFO(int rep) throws HL7Exception {
        return (ADT_AXX_MERGE_INFO)super.insertRepetition("MERGE_INFO", rep);
    }

    public ADT_AXX_MERGE_INFO removeMERGE_INFO(int rep) throws HL7Exception {
        return (ADT_AXX_MERGE_INFO)super.removeRepetition("MERGE_INFO", rep);
    }

    public IAM getIAM() {
        return (IAM)this.getTyped("IAM", IAM.class);
    }

    public IAM getIAM(int rep) {
        return (IAM)this.getTyped("IAM", rep, IAM.class);
    }

    public int getIAMReps() {
        return this.getReps("IAM");
    }

    public List<IAM> getIAMAll() throws HL7Exception {
        return this.getAllAsList("IAM", IAM.class);
    }

    public void insertIAM(IAM structure, int rep) throws HL7Exception {
        super.insertRepetition("IAM", (Structure)structure, rep);
    }

    public IAM insertIAM(int rep) throws HL7Exception {
        return (IAM)super.insertRepetition("IAM", rep);
    }

    public IAM removeIAM(int rep) throws HL7Exception {
        return (IAM)super.removeRepetition("IAM", rep);
    }
}

