/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 PL (Person Location) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Point of Care (IS)
 * <li>Room (IS)
 * <li>Bed (IS)
 * <li>Facility (HD)
 * <li>Location Status (IS)
 * <li>Person Location Type (IS)
 * <li>Building (IS)
 * <li>Floor (IS)
 * <li>Location Description (ST)
 * <li>Comprehensive Location Identifier (EI)
 * <li>Assigning Authority for Location (HD)
 * </ul>
 */
public class PL extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new PL type
     */
    public PL(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[11];    
        data[0] = new IS(getMessage(), 302);
        data[1] = new IS(getMessage(), 303);
        data[2] = new IS(getMessage(), 304);
        data[3] = new HD(getMessage());
        data[4] = new IS(getMessage(), 306);
        data[5] = new IS(getMessage(), 305);
        data[6] = new IS(getMessage(), 307);
        data[7] = new IS(getMessage(), 308);
        data[8] = new ST(getMessage());
        data[9] = new EI(getMessage());
        data[10] = new HD(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Point of Care (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getPointOfCare() {
       IS ret = null;
       try {
          ret = (IS)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Point of Care (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getPl1_PointOfCare() {
       IS ret = null;
       try {
          ret = (IS)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Room (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getRoom() {
       IS ret = null;
       try {
          ret = (IS)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Room (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getPl2_Room() {
       IS ret = null;
       try {
          ret = (IS)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Bed (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getBed() {
       IS ret = null;
       try {
          ret = (IS)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Bed (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getPl3_Bed() {
       IS ret = null;
       try {
          ret = (IS)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Facility (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getFacility() {
       HD ret = null;
       try {
          ret = (HD)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Facility (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getPl4_Facility() {
       HD ret = null;
       try {
          ret = (HD)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Location Status (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getLocationStatus() {
       IS ret = null;
       try {
          ret = (IS)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Location Status (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getPl5_LocationStatus() {
       IS ret = null;
       try {
          ret = (IS)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Person Location Type (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getPersonLocationType() {
       IS ret = null;
       try {
          ret = (IS)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Person Location Type (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getPl6_PersonLocationType() {
       IS ret = null;
       try {
          ret = (IS)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Building (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getBuilding() {
       IS ret = null;
       try {
          ret = (IS)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Building (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getPl7_Building() {
       IS ret = null;
       try {
          ret = (IS)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Floor (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getFloor() {
       IS ret = null;
       try {
          ret = (IS)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Floor (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getPl8_Floor() {
       IS ret = null;
       try {
          ret = (IS)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Location Description (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getLocationDescription() {
       ST ret = null;
       try {
          ret = (ST)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Location Description (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getPl9_LocationDescription() {
       ST ret = null;
       try {
          ret = (ST)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Comprehensive Location Identifier (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public EI getComprehensiveLocationIdentifier() {
       EI ret = null;
       try {
          ret = (EI)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Comprehensive Location Identifier (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public EI getPl10_ComprehensiveLocationIdentifier() {
       EI ret = null;
       try {
          ret = (EI)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Assigning Authority for Location (component #11).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getAssigningAuthorityForLocation() {
       HD ret = null;
       try {
          ret = (HD)getComponent(10);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Assigning Authority for Location (component #11).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getPl11_AssigningAuthorityForLocation() {
       HD ret = null;
       try {
          ret = (HD)getComponent(10);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

