/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 TS (Time Stamp) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Time (DTM)
 * <li>Degree of Precision (ID)
 * </ul>
 */
public class TS extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new TS type
     */
    public TS(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[2];    
        data[0] = new DTM(getMessage());
        data[1] = new ID(getMessage(), 529);
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Time (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DTM getTime() {
       DTM ret = null;
       try {
          ret = (DTM)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Time (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DTM getTs1_Time() {
       DTM ret = null;
       try {
          ret = (DTM)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Degree of Precision (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getDegreeOfPrecision() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Degree of Precision (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getTs2_DegreeOfPrecision() {
       ID ret = null;
       try {
          ret = (ID)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

