/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.model.v25.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a MFR_M06_MF_QUERY group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: MFE (Master File Entry) <b> </b></li>
                 * <li>2: CM0 (Clinical Study Master) <b> </b></li>
                 * <li>3: CM1 (Clinical Study Phase Master) <b>optional repeating</b></li>
                 * <li>4: CM2 (Clinical Study Schedule Master) <b>optional repeating</b></li>
 * </ul>
 */
public class MFR_M06_MF_QUERY extends AbstractGroup {

    /** 
     * Creates a new MFR_M06_MF_QUERY group
     */
    public MFR_M06_MF_QUERY(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MFE.class, true, false);
                          this.add(CM0.class, true, false);
                          this.add(CM1.class, false, true);
                          this.add(CM2.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MFR_M06_MF_QUERY - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.5"
     */
    public String getVersion() {
       return "2.5";
    }



    /**
     * Returns
     * MFE (Master File Entry) - creates it if necessary
     */
    public MFE getMFE() { 
       MFE ret = null;
       try {
          ret = (MFE)this.get("MFE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * CM0 (Clinical Study Master) - creates it if necessary
     */
    public CM0 getCM0() { 
       CM0 ret = null;
       try {
          ret = (CM0)this.get("CM0");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * CM1 (Clinical Study Phase Master) - creates it if necessary
     */
    public CM1 getCM1() { 
       CM1 ret = null;
       try {
          ret = (CM1)this.get("CM1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * CM1 (Clinical Study Phase Master) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public CM1 getCM1(int rep) { 
       CM1 ret = null;
       try {
          ret = (CM1)this.get("CM1", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of CM1 
     */ 
    public int getCM1Reps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("CM1").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of CM1 (Clinical Study Phase Master)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertCM1(CM1 structure, int rep) throws HL7Exception { 
       super.insertRepetition("CM1", structure, rep);
    }


    /**
     * Inserts a specific repetition of CM1 (Clinical Study Phase Master)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public CM1 insertCM1(int rep) throws HL7Exception { 
       return (CM1)super.insertRepetition("CM1", rep);
    }


    /**
     * Removes a specific repetition of CM1 (Clinical Study Phase Master)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public CM1 removeCM1(int rep) throws HL7Exception { 
       return (CM1)super.removeRepetition("CM1", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * CM2 (Clinical Study Schedule Master) - creates it if necessary
     */
    public CM2 getCM2() { 
       CM2 ret = null;
       try {
          ret = (CM2)this.get("CM2");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * CM2 (Clinical Study Schedule Master) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public CM2 getCM2(int rep) { 
       CM2 ret = null;
       try {
          ret = (CM2)this.get("CM2", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of CM2 
     */ 
    public int getCM2Reps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("CM2").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of CM2 (Clinical Study Schedule Master)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertCM2(CM2 structure, int rep) throws HL7Exception { 
       super.insertRepetition("CM2", structure, rep);
    }


    /**
     * Inserts a specific repetition of CM2 (Clinical Study Schedule Master)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public CM2 insertCM2(int rep) throws HL7Exception { 
       return (CM2)super.insertRepetition("CM2", rep);
    }


    /**
     * Removes a specific repetition of CM2 (Clinical Study Schedule Master)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public CM2 removeCM2(int rep) throws HL7Exception { 
       return (CM2)super.removeRepetition("CM2", rep);
    }



}

