/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.model.v25.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a ORL_O34_OBSERVATION_REQUEST group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: OBR (Observation Request) <b> </b></li>
                 * <li>2: ORL_O34_ORDER_SPECIMEN (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class ORL_O34_OBSERVATION_REQUEST extends AbstractGroup {

    /** 
     * Creates a new ORL_O34_OBSERVATION_REQUEST group
     */
    public ORL_O34_OBSERVATION_REQUEST(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(OBR.class, true, false);
                          this.add(ORL_O34_ORDER_SPECIMEN.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORL_O34_OBSERVATION_REQUEST - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.5"
     */
    public String getVersion() {
       return "2.5";
    }



    /**
     * Returns
     * OBR (Observation Request) - creates it if necessary
     */
    public OBR getOBR() { 
       OBR ret = null;
       try {
          ret = (OBR)this.get("OBR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ORDER_SPECIMEN (a Group object) - creates it if necessary
     */
    public ORL_O34_ORDER_SPECIMEN getORDER_SPECIMEN() { 
       ORL_O34_ORDER_SPECIMEN ret = null;
       try {
          ret = (ORL_O34_ORDER_SPECIMEN)this.get("ORDER_SPECIMEN");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORDER_SPECIMEN (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ORL_O34_ORDER_SPECIMEN getORDER_SPECIMEN(int rep) { 
       ORL_O34_ORDER_SPECIMEN ret = null;
       try {
          ret = (ORL_O34_ORDER_SPECIMEN)this.get("ORDER_SPECIMEN", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORDER_SPECIMEN 
     */ 
    public int getORDER_SPECIMENReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORDER_SPECIMEN").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORDER_SPECIMEN (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertORDER_SPECIMEN(ORL_O34_ORDER_SPECIMEN structure, int rep) throws HL7Exception { 
       super.insertRepetition("ORDER_SPECIMEN", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORDER_SPECIMEN (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public ORL_O34_ORDER_SPECIMEN insertORDER_SPECIMEN(int rep) throws HL7Exception { 
       return (ORL_O34_ORDER_SPECIMEN)super.insertRepetition("ORDER_SPECIMEN", rep);
    }


    /**
     * Removes a specific repetition of ORDER_SPECIMEN (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public ORL_O34_ORDER_SPECIMEN removeORDER_SPECIMEN(int rep) throws HL7Exception { 
       return (ORL_O34_ORDER_SPECIMEN)super.removeRepetition("ORDER_SPECIMEN", rep);
    }



}

