/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.model.v25.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a RRI_I12_PROCEDURE group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: PR1 (Procedures) <b> </b></li>
                 * <li>2: RRI_I12_AUTHORIZATION_CONTACT (a Group object) <b>optional </b></li>
 * </ul>
 */
public class RRI_I12_PROCEDURE extends AbstractGroup {

    /** 
     * Creates a new RRI_I12_PROCEDURE group
     */
    public RRI_I12_PROCEDURE(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(PR1.class, true, false);
                          this.add(RRI_I12_AUTHORIZATION_CONTACT.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RRI_I12_PROCEDURE - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.5"
     */
    public String getVersion() {
       return "2.5";
    }



    /**
     * Returns
     * PR1 (Procedures) - creates it if necessary
     */
    public PR1 getPR1() { 
       PR1 ret = null;
       try {
          ret = (PR1)this.get("PR1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * AUTHORIZATION_CONTACT (a Group object) - creates it if necessary
     */
    public RRI_I12_AUTHORIZATION_CONTACT getAUTHORIZATION_CONTACT() { 
       RRI_I12_AUTHORIZATION_CONTACT ret = null;
       try {
          ret = (RRI_I12_AUTHORIZATION_CONTACT)this.get("AUTHORIZATION_CONTACT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

