/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.segment;

// import ca.uhn.hl7v2.model.v25.group.*;
import ca.uhn.hl7v2.model.v25.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 APR message segment (Appointment Preferences). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>APR-1: Time Selection Criteria (SCV) <b>optional repeating</b>
     * <li>APR-2: Resource Selection Criteria (SCV) <b>optional repeating</b>
     * <li>APR-3: Location Selection Criteria (SCV) <b>optional repeating</b>
     * <li>APR-4: Slot Spacing Criteria (NM) <b>optional </b>
     * <li>APR-5: Filler Override Criteria (SCV) <b>optional repeating</b>
 * </ul>
 */
public class APR extends AbstractSegment {

    /** 
     * Creates a new APR segment
     */
    public APR(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SCV.class, false, 0, 80, new Object[]{ getMessage(), new Integer(294) }, "Time Selection Criteria");
                                  this.add(SCV.class, false, 0, 80, new Object[]{ getMessage(), new Integer(294) }, "Resource Selection Criteria");
                                  this.add(SCV.class, false, 0, 80, new Object[]{ getMessage(), new Integer(294) }, "Location Selection Criteria");
                                  this.add(NM.class, false, 1, 5, new Object[]{ getMessage(), new Integer(0) }, "Slot Spacing Criteria");
                                  this.add(SCV.class, false, 0, 80, new Object[]{ getMessage(), new Integer(0) }, "Filler Override Criteria");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating APR - this is probably a bug in the source code generator.", e);
       }
    }


    /**
     * Returns all repetitions of Time Selection Criteria (APR-1).
     */
    public SCV[] getTimeSelectionCriteria() {
        SCV[] ret = null;
        try {
            Type[] t = this.getField(1);  
            ret = new SCV[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (SCV)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * APR-1: "Time Selection Criteria" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public SCV getTimeSelectionCriteria(int rep) { 
        SCV ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (SCV)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * APR-1: "Time Selection Criteria" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public SCV getApr1_TimeSelectionCriteria(int rep) { 
        SCV ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (SCV)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * APR-1: "Time Selection Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SCV insertTimeSelectionCriteria(int rep) throws HL7Exception { 
        return (SCV) super.insertRepetition(1, rep);
    }



    /**
     * Inserts a repetition of
     * APR-1: "Time Selection Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SCV insertApr1_TimeSelectionCriteria(int rep) throws HL7Exception { 
        return (SCV) super.insertRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * APR-1: "Time Selection Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SCV removeTimeSelectionCriteria(int rep) throws HL7Exception { 
        return (SCV) super.removeRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * APR-1: "Time Selection Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SCV removeApr1_TimeSelectionCriteria(int rep) throws HL7Exception { 
        return (SCV) super.removeRepetition(1, rep);
    }



    /**
     * Returns all repetitions of Resource Selection Criteria (APR-2).
     */
    public SCV[] getResourceSelectionCriteria() {
        SCV[] ret = null;
        try {
            Type[] t = this.getField(2);  
            ret = new SCV[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (SCV)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * APR-2: "Resource Selection Criteria" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public SCV getResourceSelectionCriteria(int rep) { 
        SCV ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (SCV)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * APR-2: "Resource Selection Criteria" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public SCV getApr2_ResourceSelectionCriteria(int rep) { 
        SCV ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (SCV)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * APR-2: "Resource Selection Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SCV insertResourceSelectionCriteria(int rep) throws HL7Exception { 
        return (SCV) super.insertRepetition(2, rep);
    }



    /**
     * Inserts a repetition of
     * APR-2: "Resource Selection Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SCV insertApr2_ResourceSelectionCriteria(int rep) throws HL7Exception { 
        return (SCV) super.insertRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * APR-2: "Resource Selection Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SCV removeResourceSelectionCriteria(int rep) throws HL7Exception { 
        return (SCV) super.removeRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * APR-2: "Resource Selection Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SCV removeApr2_ResourceSelectionCriteria(int rep) throws HL7Exception { 
        return (SCV) super.removeRepetition(2, rep);
    }



    /**
     * Returns all repetitions of Location Selection Criteria (APR-3).
     */
    public SCV[] getLocationSelectionCriteria() {
        SCV[] ret = null;
        try {
            Type[] t = this.getField(3);  
            ret = new SCV[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (SCV)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * APR-3: "Location Selection Criteria" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public SCV getLocationSelectionCriteria(int rep) { 
        SCV ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (SCV)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * APR-3: "Location Selection Criteria" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public SCV getApr3_LocationSelectionCriteria(int rep) { 
        SCV ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (SCV)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * APR-3: "Location Selection Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SCV insertLocationSelectionCriteria(int rep) throws HL7Exception { 
        return (SCV) super.insertRepetition(3, rep);
    }



    /**
     * Inserts a repetition of
     * APR-3: "Location Selection Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SCV insertApr3_LocationSelectionCriteria(int rep) throws HL7Exception { 
        return (SCV) super.insertRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * APR-3: "Location Selection Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SCV removeLocationSelectionCriteria(int rep) throws HL7Exception { 
        return (SCV) super.removeRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * APR-3: "Location Selection Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SCV removeApr3_LocationSelectionCriteria(int rep) throws HL7Exception { 
        return (SCV) super.removeRepetition(3, rep);
    }




    /**
     * Returns
     * APR-4: "Slot Spacing Criteria" - creates it if necessary
     */
    public NM getSlotSpacingCriteria() { 
        NM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * APR-4: "Slot Spacing Criteria" - creates it if necessary
     */
    public NM getApr4_SlotSpacingCriteria() { 
        NM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Filler Override Criteria (APR-5).
     */
    public SCV[] getFillerOverrideCriteria() {
        SCV[] ret = null;
        try {
            Type[] t = this.getField(5);  
            ret = new SCV[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (SCV)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * APR-5: "Filler Override Criteria" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public SCV getFillerOverrideCriteria(int rep) { 
        SCV ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (SCV)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * APR-5: "Filler Override Criteria" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public SCV getApr5_FillerOverrideCriteria(int rep) { 
        SCV ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (SCV)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * APR-5: "Filler Override Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SCV insertFillerOverrideCriteria(int rep) throws HL7Exception { 
        return (SCV) super.insertRepetition(5, rep);
    }



    /**
     * Inserts a repetition of
     * APR-5: "Filler Override Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SCV insertApr5_FillerOverrideCriteria(int rep) throws HL7Exception { 
        return (SCV) super.insertRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * APR-5: "Filler Override Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SCV removeFillerOverrideCriteria(int rep) throws HL7Exception { 
        return (SCV) super.removeRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * APR-5: "Filler Override Criteria" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SCV removeApr5_FillerOverrideCriteria(int rep) throws HL7Exception { 
        return (SCV) super.removeRepetition(5, rep);
    }






    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SCV(getMessage());
          case 1: return new SCV(getMessage());
          case 2: return new SCV(getMessage());
          case 3: return new NM(getMessage());
          case 4: return new SCV(getMessage());
          default: return null;
       }
   }


}

