/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.segment;

// import ca.uhn.hl7v2.model.v25.group.*;
import ca.uhn.hl7v2.model.v25.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 DRG message segment (Diagnosis Related Group). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>DRG-1: Diagnostic Related Group (CE) <b>optional </b>
     * <li>DRG-2: DRG Assigned Date/Time (TS) <b>optional </b>
     * <li>DRG-3: DRG Approval Indicator (ID) <b>optional </b>
     * <li>DRG-4: DRG Grouper Review Code (IS) <b>optional </b>
     * <li>DRG-5: Outlier Type (CE) <b>optional </b>
     * <li>DRG-6: Outlier Days (NM) <b>optional </b>
     * <li>DRG-7: Outlier Cost (CP) <b>optional </b>
     * <li>DRG-8: DRG Payor (IS) <b>optional </b>
     * <li>DRG-9: Outlier Reimbursement (CP) <b>optional </b>
     * <li>DRG-10: Confidential Indicator (ID) <b>optional </b>
     * <li>DRG-11: DRG Transfer Type (IS) <b>optional </b>
 * </ul>
 */
public class DRG extends AbstractSegment {

    /** 
     * Creates a new DRG segment
     */
    public DRG(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(55) }, "Diagnostic Related Group");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "DRG Assigned Date/Time");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "DRG Approval Indicator");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "DRG Grouper Review Code");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(83) }, "Outlier Type");
                                  this.add(NM.class, false, 1, 3, new Object[]{ getMessage(), new Integer(0) }, "Outlier Days");
                                  this.add(CP.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Outlier Cost");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "DRG Payor");
                                  this.add(CP.class, false, 1, 9, new Object[]{ getMessage(), new Integer(0) }, "Outlier Reimbursement");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Confidential Indicator");
                                  this.add(IS.class, false, 1, 21, new Object[]{ getMessage() }, "DRG Transfer Type");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating DRG - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * DRG-1: "Diagnostic Related Group" - creates it if necessary
     */
    public CE getDiagnosticRelatedGroup() { 
        CE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-1: "Diagnostic Related Group" - creates it if necessary
     */
    public CE getDrg1_DiagnosticRelatedGroup() { 
        CE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-2: "DRG Assigned Date/Time" - creates it if necessary
     */
    public TS getDRGAssignedDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-2: "DRG Assigned Date/Time" - creates it if necessary
     */
    public TS getDrg2_DRGAssignedDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-3: "DRG Approval Indicator" - creates it if necessary
     */
    public ID getDRGApprovalIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-3: "DRG Approval Indicator" - creates it if necessary
     */
    public ID getDrg3_DRGApprovalIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-4: "DRG Grouper Review Code" - creates it if necessary
     */
    public IS getDRGGrouperReviewCode() { 
        IS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-4: "DRG Grouper Review Code" - creates it if necessary
     */
    public IS getDrg4_DRGGrouperReviewCode() { 
        IS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-5: "Outlier Type" - creates it if necessary
     */
    public CE getOutlierType() { 
        CE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-5: "Outlier Type" - creates it if necessary
     */
    public CE getDrg5_OutlierType() { 
        CE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-6: "Outlier Days" - creates it if necessary
     */
    public NM getOutlierDays() { 
        NM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-6: "Outlier Days" - creates it if necessary
     */
    public NM getDrg6_OutlierDays() { 
        NM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-7: "Outlier Cost" - creates it if necessary
     */
    public CP getOutlierCost() { 
        CP ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-7: "Outlier Cost" - creates it if necessary
     */
    public CP getDrg7_OutlierCost() { 
        CP ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-8: "DRG Payor" - creates it if necessary
     */
    public IS getDRGPayor() { 
        IS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-8: "DRG Payor" - creates it if necessary
     */
    public IS getDrg8_DRGPayor() { 
        IS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-9: "Outlier Reimbursement" - creates it if necessary
     */
    public CP getOutlierReimbursement() { 
        CP ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-9: "Outlier Reimbursement" - creates it if necessary
     */
    public CP getDrg9_OutlierReimbursement() { 
        CP ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-10: "Confidential Indicator" - creates it if necessary
     */
    public ID getConfidentialIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-10: "Confidential Indicator" - creates it if necessary
     */
    public ID getDrg10_ConfidentialIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * DRG-11: "DRG Transfer Type" - creates it if necessary
     */
    public IS getDRGTransferType() { 
        IS ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * DRG-11: "DRG Transfer Type" - creates it if necessary
     */
    public IS getDrg11_DRGTransferType() { 
        IS ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CE(getMessage());
          case 1: return new TS(getMessage());
          case 2: return new ID(getMessage(), new Integer( 136 ));
          case 3: return new IS(getMessage(), new Integer( 56 ));
          case 4: return new CE(getMessage());
          case 5: return new NM(getMessage());
          case 6: return new CP(getMessage());
          case 7: return new IS(getMessage(), new Integer( 229 ));
          case 8: return new CP(getMessage());
          case 9: return new ID(getMessage(), new Integer( 136 ));
          case 10: return new IS(getMessage(), new Integer( 415 ));
          default: return null;
       }
   }


}

