/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.segment;

// import ca.uhn.hl7v2.model.v25.group.*;
import ca.uhn.hl7v2.model.v25.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 PDA message segment (Patient Death and Autopsy). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>PDA-1: Death Cause Code (CE) <b>optional repeating</b>
     * <li>PDA-2: Death Location (PL) <b>optional </b>
     * <li>PDA-3: Death Certified Indicator (ID) <b>optional </b>
     * <li>PDA-4: Death Certificate Signed Date/Time (TS) <b>optional </b>
     * <li>PDA-5: Death Certified By (XCN) <b>optional </b>
     * <li>PDA-6: Autopsy Indicator (ID) <b>optional </b>
     * <li>PDA-7: Autopsy Start and End Date/Time (DR) <b>optional </b>
     * <li>PDA-8: Autopsy Performed By (XCN) <b>optional </b>
     * <li>PDA-9: Coroner Indicator (ID) <b>optional </b>
 * </ul>
 */
public class PDA extends AbstractSegment {

    /** 
     * Creates a new PDA segment
     */
    public PDA(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Death Cause Code");
                                  this.add(PL.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "Death Location");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Death Certified Indicator");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Death Certificate Signed Date/Time");
                                  this.add(XCN.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Death Certified By");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Autopsy Indicator");
                                  this.add(DR.class, false, 1, 53, new Object[]{ getMessage(), new Integer(0) }, "Autopsy Start and End Date/Time");
                                  this.add(XCN.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Autopsy Performed By");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Coroner Indicator");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PDA - this is probably a bug in the source code generator.", e);
       }
    }


    /**
     * Returns all repetitions of Death Cause Code (PDA-1).
     */
    public CE[] getDeathCauseCode() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(1);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PDA-1: "Death Cause Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getDeathCauseCode(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PDA-1: "Death Cause Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getPda1_DeathCauseCode(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PDA-1: "Death Cause Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertDeathCauseCode(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(1, rep);
    }



    /**
     * Inserts a repetition of
     * PDA-1: "Death Cause Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertPda1_DeathCauseCode(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * PDA-1: "Death Cause Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeDeathCauseCode(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * PDA-1: "Death Cause Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removePda1_DeathCauseCode(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(1, rep);
    }




    /**
     * Returns
     * PDA-2: "Death Location" - creates it if necessary
     */
    public PL getDeathLocation() { 
        PL ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (PL)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PDA-2: "Death Location" - creates it if necessary
     */
    public PL getPda2_DeathLocation() { 
        PL ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (PL)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PDA-3: "Death Certified Indicator" - creates it if necessary
     */
    public ID getDeathCertifiedIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PDA-3: "Death Certified Indicator" - creates it if necessary
     */
    public ID getPda3_DeathCertifiedIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PDA-4: "Death Certificate Signed Date/Time" - creates it if necessary
     */
    public TS getDeathCertificateSignedDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PDA-4: "Death Certificate Signed Date/Time" - creates it if necessary
     */
    public TS getPda4_DeathCertificateSignedDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PDA-5: "Death Certified By" - creates it if necessary
     */
    public XCN getDeathCertifiedBy() { 
        XCN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PDA-5: "Death Certified By" - creates it if necessary
     */
    public XCN getPda5_DeathCertifiedBy() { 
        XCN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PDA-6: "Autopsy Indicator" - creates it if necessary
     */
    public ID getAutopsyIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PDA-6: "Autopsy Indicator" - creates it if necessary
     */
    public ID getPda6_AutopsyIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PDA-7: "Autopsy Start and End Date/Time" - creates it if necessary
     */
    public DR getAutopsyStartAndEndDateTime() { 
        DR ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (DR)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PDA-7: "Autopsy Start and End Date/Time" - creates it if necessary
     */
    public DR getPda7_AutopsyStartAndEndDateTime() { 
        DR ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (DR)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PDA-8: "Autopsy Performed By" - creates it if necessary
     */
    public XCN getAutopsyPerformedBy() { 
        XCN ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PDA-8: "Autopsy Performed By" - creates it if necessary
     */
    public XCN getPda8_AutopsyPerformedBy() { 
        XCN ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PDA-9: "Coroner Indicator" - creates it if necessary
     */
    public ID getCoronerIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PDA-9: "Coroner Indicator" - creates it if necessary
     */
    public ID getPda9_CoronerIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CE(getMessage());
          case 1: return new PL(getMessage());
          case 2: return new ID(getMessage(), new Integer( 136 ));
          case 3: return new TS(getMessage());
          case 4: return new XCN(getMessage());
          case 5: return new ID(getMessage(), new Integer( 136 ));
          case 6: return new DR(getMessage());
          case 7: return new XCN(getMessage());
          case 8: return new ID(getMessage(), new Integer( 136 ));
          default: return null;
       }
   }


}

