/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.segment.LCC;
import ca.uhn.hl7v2.model.v25.segment.LCH;
import ca.uhn.hl7v2.model.v25.segment.LDP;
import ca.uhn.hl7v2.model.v25.segment.LOC;
import ca.uhn.hl7v2.model.v25.segment.LRL;
import ca.uhn.hl7v2.model.v25.segment.MFE;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFR_M05_MF_QUERY
extends AbstractGroup {
    public MFR_M05_MF_QUERY(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MFE.class, true, false);
            this.add(LOC.class, true, false);
            this.add(LCH.class, false, true);
            this.add(LRL.class, false, true);
            this.add(LDP.class, true, true);
            this.add(LCH.class, false, true);
            this.add(LCC.class, false, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating MFR_M05_MF_QUERY - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public MFE getMFE() {
        MFE retVal = (MFE)this.getTyped("MFE", MFE.class);
        return retVal;
    }

    public LOC getLOC() {
        LOC retVal = (LOC)this.getTyped("LOC", LOC.class);
        return retVal;
    }

    public LCH getLCH() {
        LCH retVal = (LCH)this.getTyped("LCH", LCH.class);
        return retVal;
    }

    public LCH getLCH(int rep) {
        LCH retVal = (LCH)this.getTyped("LCH", rep, LCH.class);
        return retVal;
    }

    public int getLCHReps() {
        return this.getReps("LCH");
    }

    public List<LCH> getLCHAll() throws HL7Exception {
        return this.getAllAsList("LCH", LCH.class);
    }

    public void insertLCH(LCH structure, int rep) throws HL7Exception {
        super.insertRepetition("LCH", (Structure)structure, rep);
    }

    public LCH insertLCH(int rep) throws HL7Exception {
        return (LCH)super.insertRepetition("LCH", rep);
    }

    public LCH removeLCH(int rep) throws HL7Exception {
        return (LCH)super.removeRepetition("LCH", rep);
    }

    public LRL getLRL() {
        LRL retVal = (LRL)this.getTyped("LRL", LRL.class);
        return retVal;
    }

    public LRL getLRL(int rep) {
        LRL retVal = (LRL)this.getTyped("LRL", rep, LRL.class);
        return retVal;
    }

    public int getLRLReps() {
        return this.getReps("LRL");
    }

    public List<LRL> getLRLAll() throws HL7Exception {
        return this.getAllAsList("LRL", LRL.class);
    }

    public void insertLRL(LRL structure, int rep) throws HL7Exception {
        super.insertRepetition("LRL", (Structure)structure, rep);
    }

    public LRL insertLRL(int rep) throws HL7Exception {
        return (LRL)super.insertRepetition("LRL", rep);
    }

    public LRL removeLRL(int rep) throws HL7Exception {
        return (LRL)super.removeRepetition("LRL", rep);
    }

    public LDP getLDP() {
        LDP retVal = (LDP)this.getTyped("LDP", LDP.class);
        return retVal;
    }

    public LDP getLDP(int rep) {
        LDP retVal = (LDP)this.getTyped("LDP", rep, LDP.class);
        return retVal;
    }

    public int getLDPReps() {
        return this.getReps("LDP");
    }

    public List<LDP> getLDPAll() throws HL7Exception {
        return this.getAllAsList("LDP", LDP.class);
    }

    public void insertLDP(LDP structure, int rep) throws HL7Exception {
        super.insertRepetition("LDP", (Structure)structure, rep);
    }

    public LDP insertLDP(int rep) throws HL7Exception {
        return (LDP)super.insertRepetition("LDP", rep);
    }

    public LDP removeLDP(int rep) throws HL7Exception {
        return (LDP)super.removeRepetition("LDP", rep);
    }

    public LCH getLCH2() {
        LCH retVal = (LCH)this.getTyped("LCH2", LCH.class);
        return retVal;
    }

    public LCH getLCH2(int rep) {
        LCH retVal = (LCH)this.getTyped("LCH2", rep, LCH.class);
        return retVal;
    }

    public int getLCH2Reps() {
        return this.getReps("LCH2");
    }

    public List<LCH> getLCH2All() throws HL7Exception {
        return this.getAllAsList("LCH2", LCH.class);
    }

    public void insertLCH2(LCH structure, int rep) throws HL7Exception {
        super.insertRepetition("LCH2", (Structure)structure, rep);
    }

    public LCH insertLCH2(int rep) throws HL7Exception {
        return (LCH)super.insertRepetition("LCH2", rep);
    }

    public LCH removeLCH2(int rep) throws HL7Exception {
        return (LCH)super.removeRepetition("LCH2", rep);
    }

    public LCC getLCC() {
        LCC retVal = (LCC)this.getTyped("LCC", LCC.class);
        return retVal;
    }

    public LCC getLCC(int rep) {
        LCC retVal = (LCC)this.getTyped("LCC", rep, LCC.class);
        return retVal;
    }

    public int getLCCReps() {
        return this.getReps("LCC");
    }

    public List<LCC> getLCCAll() throws HL7Exception {
        return this.getAllAsList("LCC", LCC.class);
    }

    public void insertLCC(LCC structure, int rep) throws HL7Exception {
        super.insertRepetition("LCC", (Structure)structure, rep);
    }

    public LCC insertLCC(int rep) throws HL7Exception {
        return (LCC)super.insertRepetition("LCC", rep);
    }

    public LCC removeLCC(int rep) throws HL7Exception {
        return (LCC)super.removeRepetition("LCC", rep);
    }
}

