/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.ORL_O36_SPECIMEN_CONTAINER;
import ca.uhn.hl7v2.model.v25.segment.OBX;
import ca.uhn.hl7v2.model.v25.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORL_O36_SPECIMEN
extends AbstractGroup {
    public ORL_O36_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, true, false);
            this.add(OBX.class, false, true);
            this.add(ORL_O36_SPECIMEN_CONTAINER.class, true, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ORL_O36_SPECIMEN - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public SPM getSPM() {
        SPM retVal = (SPM)this.getTyped("SPM", SPM.class);
        return retVal;
    }

    public OBX getOBX() {
        OBX retVal = (OBX)this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = (OBX)this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", (Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public ORL_O36_SPECIMEN_CONTAINER getSPECIMEN_CONTAINER() {
        ORL_O36_SPECIMEN_CONTAINER retVal = (ORL_O36_SPECIMEN_CONTAINER)this.getTyped("SPECIMEN_CONTAINER", ORL_O36_SPECIMEN_CONTAINER.class);
        return retVal;
    }

    public ORL_O36_SPECIMEN_CONTAINER getSPECIMEN_CONTAINER(int rep) {
        ORL_O36_SPECIMEN_CONTAINER retVal = (ORL_O36_SPECIMEN_CONTAINER)this.getTyped("SPECIMEN_CONTAINER", rep, ORL_O36_SPECIMEN_CONTAINER.class);
        return retVal;
    }

    public int getSPECIMEN_CONTAINERReps() {
        return this.getReps("SPECIMEN_CONTAINER");
    }

    public List<ORL_O36_SPECIMEN_CONTAINER> getSPECIMEN_CONTAINERAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN_CONTAINER", ORL_O36_SPECIMEN_CONTAINER.class);
    }

    public void insertSPECIMEN_CONTAINER(ORL_O36_SPECIMEN_CONTAINER structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN_CONTAINER", (Structure)structure, rep);
    }

    public ORL_O36_SPECIMEN_CONTAINER insertSPECIMEN_CONTAINER(int rep) throws HL7Exception {
        return (ORL_O36_SPECIMEN_CONTAINER)super.insertRepetition("SPECIMEN_CONTAINER", rep);
    }

    public ORL_O36_SPECIMEN_CONTAINER removeSPECIMEN_CONTAINER(int rep) throws HL7Exception {
        return (ORL_O36_SPECIMEN_CONTAINER)super.removeRepetition("SPECIMEN_CONTAINER", rep);
    }
}

