/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.OUL_R22_RESULT;
import ca.uhn.hl7v2.model.v25.group.OUL_R22_TIMING_QTY;
import ca.uhn.hl7v2.model.v25.segment.CTI;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.OBR;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OUL_R22_ORDER
extends AbstractGroup {
    public OUL_R22_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false);
            this.add(ORC.class, false, false);
            this.add(NTE.class, false, true);
            this.add(OUL_R22_TIMING_QTY.class, false, true);
            this.add(OUL_R22_RESULT.class, false, true);
            this.add(CTI.class, false, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OUL_R22_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public OBR getOBR() {
        OBR retVal = (OBR)this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public OUL_R22_TIMING_QTY getTIMING_QTY() {
        OUL_R22_TIMING_QTY retVal = (OUL_R22_TIMING_QTY)this.getTyped("TIMING_QTY", OUL_R22_TIMING_QTY.class);
        return retVal;
    }

    public OUL_R22_TIMING_QTY getTIMING_QTY(int rep) {
        OUL_R22_TIMING_QTY retVal = (OUL_R22_TIMING_QTY)this.getTyped("TIMING_QTY", rep, OUL_R22_TIMING_QTY.class);
        return retVal;
    }

    public int getTIMING_QTYReps() {
        return this.getReps("TIMING_QTY");
    }

    public List<OUL_R22_TIMING_QTY> getTIMING_QTYAll() throws HL7Exception {
        return this.getAllAsList("TIMING_QTY", OUL_R22_TIMING_QTY.class);
    }

    public void insertTIMING_QTY(OUL_R22_TIMING_QTY structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING_QTY", (Structure)structure, rep);
    }

    public OUL_R22_TIMING_QTY insertTIMING_QTY(int rep) throws HL7Exception {
        return (OUL_R22_TIMING_QTY)super.insertRepetition("TIMING_QTY", rep);
    }

    public OUL_R22_TIMING_QTY removeTIMING_QTY(int rep) throws HL7Exception {
        return (OUL_R22_TIMING_QTY)super.removeRepetition("TIMING_QTY", rep);
    }

    public OUL_R22_RESULT getRESULT() {
        OUL_R22_RESULT retVal = (OUL_R22_RESULT)this.getTyped("RESULT", OUL_R22_RESULT.class);
        return retVal;
    }

    public OUL_R22_RESULT getRESULT(int rep) {
        OUL_R22_RESULT retVal = (OUL_R22_RESULT)this.getTyped("RESULT", rep, OUL_R22_RESULT.class);
        return retVal;
    }

    public int getRESULTReps() {
        return this.getReps("RESULT");
    }

    public List<OUL_R22_RESULT> getRESULTAll() throws HL7Exception {
        return this.getAllAsList("RESULT", OUL_R22_RESULT.class);
    }

    public void insertRESULT(OUL_R22_RESULT structure, int rep) throws HL7Exception {
        super.insertRepetition("RESULT", (Structure)structure, rep);
    }

    public OUL_R22_RESULT insertRESULT(int rep) throws HL7Exception {
        return (OUL_R22_RESULT)super.insertRepetition("RESULT", rep);
    }

    public OUL_R22_RESULT removeRESULT(int rep) throws HL7Exception {
        return (OUL_R22_RESULT)super.removeRepetition("RESULT", rep);
    }

    public CTI getCTI() {
        CTI retVal = (CTI)this.getTyped("CTI", CTI.class);
        return retVal;
    }

    public CTI getCTI(int rep) {
        CTI retVal = (CTI)this.getTyped("CTI", rep, CTI.class);
        return retVal;
    }

    public int getCTIReps() {
        return this.getReps("CTI");
    }

    public List<CTI> getCTIAll() throws HL7Exception {
        return this.getAllAsList("CTI", CTI.class);
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", (Structure)structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }
}

