/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.PTR_PCF_PATHWAY_ROLE;
import ca.uhn.hl7v2.model.v25.group.PTR_PCF_PROBLEM;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.PTH;
import ca.uhn.hl7v2.model.v25.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PTR_PCF_PATHWAY
extends AbstractGroup {
    public PTR_PCF_PATHWAY(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PTH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(VAR.class, false, true);
            this.add(PTR_PCF_PATHWAY_ROLE.class, false, true);
            this.add(PTR_PCF_PROBLEM.class, false, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating PTR_PCF_PATHWAY - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public PTH getPTH() {
        PTH retVal = (PTH)this.getTyped("PTH", PTH.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public VAR getVAR() {
        VAR retVal = (VAR)this.getTyped("VAR", VAR.class);
        return retVal;
    }

    public VAR getVAR(int rep) {
        VAR retVal = (VAR)this.getTyped("VAR", rep, VAR.class);
        return retVal;
    }

    public int getVARReps() {
        return this.getReps("VAR");
    }

    public List<VAR> getVARAll() throws HL7Exception {
        return this.getAllAsList("VAR", VAR.class);
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", (Structure)structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public PTR_PCF_PATHWAY_ROLE getPATHWAY_ROLE() {
        PTR_PCF_PATHWAY_ROLE retVal = (PTR_PCF_PATHWAY_ROLE)this.getTyped("PATHWAY_ROLE", PTR_PCF_PATHWAY_ROLE.class);
        return retVal;
    }

    public PTR_PCF_PATHWAY_ROLE getPATHWAY_ROLE(int rep) {
        PTR_PCF_PATHWAY_ROLE retVal = (PTR_PCF_PATHWAY_ROLE)this.getTyped("PATHWAY_ROLE", rep, PTR_PCF_PATHWAY_ROLE.class);
        return retVal;
    }

    public int getPATHWAY_ROLEReps() {
        return this.getReps("PATHWAY_ROLE");
    }

    public List<PTR_PCF_PATHWAY_ROLE> getPATHWAY_ROLEAll() throws HL7Exception {
        return this.getAllAsList("PATHWAY_ROLE", PTR_PCF_PATHWAY_ROLE.class);
    }

    public void insertPATHWAY_ROLE(PTR_PCF_PATHWAY_ROLE structure, int rep) throws HL7Exception {
        super.insertRepetition("PATHWAY_ROLE", (Structure)structure, rep);
    }

    public PTR_PCF_PATHWAY_ROLE insertPATHWAY_ROLE(int rep) throws HL7Exception {
        return (PTR_PCF_PATHWAY_ROLE)super.insertRepetition("PATHWAY_ROLE", rep);
    }

    public PTR_PCF_PATHWAY_ROLE removePATHWAY_ROLE(int rep) throws HL7Exception {
        return (PTR_PCF_PATHWAY_ROLE)super.removeRepetition("PATHWAY_ROLE", rep);
    }

    public PTR_PCF_PROBLEM getPROBLEM() {
        PTR_PCF_PROBLEM retVal = (PTR_PCF_PROBLEM)this.getTyped("PROBLEM", PTR_PCF_PROBLEM.class);
        return retVal;
    }

    public PTR_PCF_PROBLEM getPROBLEM(int rep) {
        PTR_PCF_PROBLEM retVal = (PTR_PCF_PROBLEM)this.getTyped("PROBLEM", rep, PTR_PCF_PROBLEM.class);
        return retVal;
    }

    public int getPROBLEMReps() {
        return this.getReps("PROBLEM");
    }

    public List<PTR_PCF_PROBLEM> getPROBLEMAll() throws HL7Exception {
        return this.getAllAsList("PROBLEM", PTR_PCF_PROBLEM.class);
    }

    public void insertPROBLEM(PTR_PCF_PROBLEM structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM", (Structure)structure, rep);
    }

    public PTR_PCF_PROBLEM insertPROBLEM(int rep) throws HL7Exception {
        return (PTR_PCF_PROBLEM)super.insertRepetition("PROBLEM", rep);
    }

    public PTR_PCF_PROBLEM removePROBLEM(int rep) throws HL7Exception {
        return (PTR_PCF_PROBLEM)super.removeRepetition("PROBLEM", rep);
    }
}

