/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.RAS_O17_OBSERVATION;
import ca.uhn.hl7v2.model.v25.segment.RXA;
import ca.uhn.hl7v2.model.v25.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAS_O17_ADMINISTRATION
extends AbstractGroup {
    public RAS_O17_ADMINISTRATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RXA.class, true, true);
            this.add(RXR.class, true, false);
            this.add(RAS_O17_OBSERVATION.class, false, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RAS_O17_ADMINISTRATION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public RXA getRXA() {
        RXA retVal = (RXA)this.getTyped("RXA", RXA.class);
        return retVal;
    }

    public RXA getRXA(int rep) {
        RXA retVal = (RXA)this.getTyped("RXA", rep, RXA.class);
        return retVal;
    }

    public int getRXAReps() {
        return this.getReps("RXA");
    }

    public List<RXA> getRXAAll() throws HL7Exception {
        return this.getAllAsList("RXA", RXA.class);
    }

    public void insertRXA(RXA structure, int rep) throws HL7Exception {
        super.insertRepetition("RXA", (Structure)structure, rep);
    }

    public RXA insertRXA(int rep) throws HL7Exception {
        return (RXA)super.insertRepetition("RXA", rep);
    }

    public RXA removeRXA(int rep) throws HL7Exception {
        return (RXA)super.removeRepetition("RXA", rep);
    }

    public RXR getRXR() {
        RXR retVal = (RXR)this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public RAS_O17_OBSERVATION getOBSERVATION() {
        RAS_O17_OBSERVATION retVal = (RAS_O17_OBSERVATION)this.getTyped("OBSERVATION", RAS_O17_OBSERVATION.class);
        return retVal;
    }

    public RAS_O17_OBSERVATION getOBSERVATION(int rep) {
        RAS_O17_OBSERVATION retVal = (RAS_O17_OBSERVATION)this.getTyped("OBSERVATION", rep, RAS_O17_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<RAS_O17_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", RAS_O17_OBSERVATION.class);
    }

    public void insertOBSERVATION(RAS_O17_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public RAS_O17_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (RAS_O17_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public RAS_O17_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (RAS_O17_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

