/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.RSP_Z90_OBSERVATION;
import ca.uhn.hl7v2.model.v25.group.RSP_Z90_TIMING;
import ca.uhn.hl7v2.model.v25.segment.CTD;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.OBR;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSP_Z90_COMMON_ORDER
extends AbstractGroup {
    public RSP_Z90_COMMON_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(RSP_Z90_TIMING.class, false, true);
            this.add(OBR.class, true, false);
            this.add(NTE.class, false, true);
            this.add(CTD.class, false, false);
            this.add(RSP_Z90_OBSERVATION.class, true, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RSP_Z90_COMMON_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public RSP_Z90_TIMING getTIMING() {
        RSP_Z90_TIMING retVal = (RSP_Z90_TIMING)this.getTyped("TIMING", RSP_Z90_TIMING.class);
        return retVal;
    }

    public RSP_Z90_TIMING getTIMING(int rep) {
        RSP_Z90_TIMING retVal = (RSP_Z90_TIMING)this.getTyped("TIMING", rep, RSP_Z90_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<RSP_Z90_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", RSP_Z90_TIMING.class);
    }

    public void insertTIMING(RSP_Z90_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public RSP_Z90_TIMING insertTIMING(int rep) throws HL7Exception {
        return (RSP_Z90_TIMING)super.insertRepetition("TIMING", rep);
    }

    public RSP_Z90_TIMING removeTIMING(int rep) throws HL7Exception {
        return (RSP_Z90_TIMING)super.removeRepetition("TIMING", rep);
    }

    public OBR getOBR() {
        OBR retVal = (OBR)this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public CTD getCTD() {
        CTD retVal = (CTD)this.getTyped("CTD", CTD.class);
        return retVal;
    }

    public RSP_Z90_OBSERVATION getOBSERVATION() {
        RSP_Z90_OBSERVATION retVal = (RSP_Z90_OBSERVATION)this.getTyped("OBSERVATION", RSP_Z90_OBSERVATION.class);
        return retVal;
    }

    public RSP_Z90_OBSERVATION getOBSERVATION(int rep) {
        RSP_Z90_OBSERVATION retVal = (RSP_Z90_OBSERVATION)this.getTyped("OBSERVATION", rep, RSP_Z90_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<RSP_Z90_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", RSP_Z90_OBSERVATION.class);
    }

    public void insertOBSERVATION(RSP_Z90_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public RSP_Z90_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (RSP_Z90_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public RSP_Z90_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (RSP_Z90_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

