/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.EI;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class IPC
extends AbstractSegment {
    public IPC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 80, new Object[]{this.getMessage()}, "Accession Identifier");
            this.add(EI.class, true, 1, 22, new Object[]{this.getMessage()}, "Requested Procedure ID");
            this.add(EI.class, true, 1, 70, new Object[]{this.getMessage()}, "Study Instance UID");
            this.add(EI.class, true, 1, 22, new Object[]{this.getMessage()}, "Scheduled Procedure Step ID");
            this.add(CE.class, false, 1, 16, new Object[]{this.getMessage()}, "Modality");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Protocol Code");
            this.add(EI.class, false, 1, 22, new Object[]{this.getMessage()}, "Scheduled Station Name");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Scheduled Procedure Step Location");
            this.add(ST.class, false, 1, 16, new Object[]{this.getMessage()}, "Scheduled AE Title");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating IPC - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI getAccessionIdentifier() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getIpc1_AccessionIdentifier() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getRequestedProcedureID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getIpc2_RequestedProcedureID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getStudyInstanceUID() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getIpc3_StudyInstanceUID() {
        EI retVal = (EI)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getScheduledProcedureStepID() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getIpc4_ScheduledProcedureStepID() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getModality() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getIpc5_Modality() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE[] getProtocolCode() {
        CE[] retVal = (CE[])this.getTypedField(6, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getIpc6_ProtocolCode() {
        CE[] retVal = (CE[])this.getTypedField(6, (Type[])new CE[0]);
        return retVal;
    }

    public int getProtocolCodeReps() {
        return this.getReps(6);
    }

    public CE getProtocolCode(int rep) {
        CE retVal = (CE)this.getTypedField(6, rep);
        return retVal;
    }

    public CE getIpc6_ProtocolCode(int rep) {
        CE retVal = (CE)this.getTypedField(6, rep);
        return retVal;
    }

    public int getIpc6_ProtocolCodeReps() {
        return this.getReps(6);
    }

    public CE insertProtocolCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(6, rep);
    }

    public CE insertIpc6_ProtocolCode(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(6, rep);
    }

    public CE removeProtocolCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(6, rep);
    }

    public CE removeIpc6_ProtocolCode(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(6, rep);
    }

    public EI getScheduledStationName() {
        EI retVal = (EI)this.getTypedField(7, 0);
        return retVal;
    }

    public EI getIpc7_ScheduledStationName() {
        EI retVal = (EI)this.getTypedField(7, 0);
        return retVal;
    }

    public CE[] getScheduledProcedureStepLocation() {
        CE[] retVal = (CE[])this.getTypedField(8, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getIpc8_ScheduledProcedureStepLocation() {
        CE[] retVal = (CE[])this.getTypedField(8, (Type[])new CE[0]);
        return retVal;
    }

    public int getScheduledProcedureStepLocationReps() {
        return this.getReps(8);
    }

    public CE getScheduledProcedureStepLocation(int rep) {
        CE retVal = (CE)this.getTypedField(8, rep);
        return retVal;
    }

    public CE getIpc8_ScheduledProcedureStepLocation(int rep) {
        CE retVal = (CE)this.getTypedField(8, rep);
        return retVal;
    }

    public int getIpc8_ScheduledProcedureStepLocationReps() {
        return this.getReps(8);
    }

    public CE insertScheduledProcedureStepLocation(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(8, rep);
    }

    public CE insertIpc8_ScheduledProcedureStepLocation(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(8, rep);
    }

    public CE removeScheduledProcedureStepLocation(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(8, rep);
    }

    public CE removeIpc8_ScheduledProcedureStepLocation(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(8, rep);
    }

    public ST getScheduledAETitle() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getIpc9_ScheduledAETitle() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new EI(this.getMessage());
            }
            case 3: {
                return new EI(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new EI(this.getMessage());
            }
            case 7: {
                return new CE(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

