/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v26.group.ORF_R04_ORDER;
import ca.uhn.hl7v2.model.v26.group.ORF_R04_PATIENT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORF_R04_QUERY_RESPONSE
extends AbstractGroup {
    public ORF_R04_QUERY_RESPONSE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORF_R04_PATIENT.class, false, false, false);
            this.add(ORF_R04_ORDER.class, true, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ORF_R04_QUERY_RESPONSE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public ORF_R04_PATIENT getPATIENT() {
        ORF_R04_PATIENT retVal = (ORF_R04_PATIENT)this.getTyped("PATIENT", ORF_R04_PATIENT.class);
        return retVal;
    }

    public ORF_R04_ORDER getORDER() {
        ORF_R04_ORDER retVal = (ORF_R04_ORDER)this.getTyped("ORDER", ORF_R04_ORDER.class);
        return retVal;
    }

    public ORF_R04_ORDER getORDER(int rep) {
        ORF_R04_ORDER retVal = (ORF_R04_ORDER)this.getTyped("ORDER", rep, ORF_R04_ORDER.class);
        return retVal;
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<ORF_R04_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", ORF_R04_ORDER.class);
    }

    public void insertORDER(ORF_R04_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public ORF_R04_ORDER insertORDER(int rep) throws HL7Exception {
        return (ORF_R04_ORDER)super.insertRepetition("ORDER", rep);
    }

    public ORF_R04_ORDER removeORDER(int rep) throws HL7Exception {
        return (ORF_R04_ORDER)super.removeRepetition("ORDER", rep);
    }
}

