/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CNE;
import ca.uhn.hl7v2.model.v26.datatype.CP;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.MO;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ITM
extends AbstractSegment {
    public ITM(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 250, new Object[]{this.getMessage()}, "Item Identifier");
            this.add(ST.class, false, 1, 999, new Object[]{this.getMessage()}, "Item Description");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Item Status");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Item Type");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Item Category");
            this.add(CNE.class, false, 1, 4, new Object[]{this.getMessage()}, "Subject to Expiration Indicator");
            this.add(EI.class, false, 1, 250, new Object[]{this.getMessage()}, "Manufacturer Identifier");
            this.add(ST.class, false, 1, 999, new Object[]{this.getMessage()}, "Manufacturer Name");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Manufacturer Catalog Number");
            this.add(CWE.class, false, 1, 4, new Object[]{this.getMessage()}, "Manufacturer Labeler Identification Code");
            this.add(CNE.class, false, 1, 4, new Object[]{this.getMessage()}, "Patient Chargeable Indicator");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Transaction Code");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage()}, "Transaction amount - unit");
            this.add(CNE.class, false, 1, 4, new Object[]{this.getMessage()}, "Stocked Item Indicator");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Supply Risk Codes");
            this.add(XON.class, false, 0, 250, new Object[]{this.getMessage()}, "Approving Regulatory Agency");
            this.add(CNE.class, false, 1, 4, new Object[]{this.getMessage()}, "Latex Indicator");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "Ruling Act");
            this.add(IS.class, false, 1, 30, new Object[]{this.getMessage(), new Integer(320)}, "Item Natural Account Code");
            this.add(NM.class, false, 1, 6, new Object[]{this.getMessage()}, "Approved To Buy Quantity");
            this.add(MO.class, false, 1, 10, new Object[]{this.getMessage()}, "Approved To Buy Price");
            this.add(CNE.class, false, 1, 4, new Object[]{this.getMessage()}, "Taxable Item Indicator");
            this.add(CNE.class, false, 1, 4, new Object[]{this.getMessage()}, "Freight Charge Indicator");
            this.add(CNE.class, false, 1, 4, new Object[]{this.getMessage()}, "Item Set Indicator");
            this.add(EI.class, false, 1, 250, new Object[]{this.getMessage()}, "Item Set Identifier");
            this.add(CNE.class, false, 1, 4, new Object[]{this.getMessage()}, "Track Department Usage Indicator");
            this.add(CNE.class, false, 1, 705, new Object[]{this.getMessage()}, "Procedure Code");
            this.add(CNE.class, false, 0, 705, new Object[]{this.getMessage()}, "Procedure Code Modifier");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Special Handling Code");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating ITM - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI getItemIdentifier() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getItm1_ItemIdentifier() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getItemDescription() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getItm2_ItemDescription() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getItemStatus() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getItm3_ItemStatus() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getItemType() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getItm4_ItemType() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getItemCategory() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getItm5_ItemCategory() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CNE getSubjectToExpirationIndicator() {
        CNE retVal = (CNE)this.getTypedField(6, 0);
        return retVal;
    }

    public CNE getItm6_SubjectToExpirationIndicator() {
        CNE retVal = (CNE)this.getTypedField(6, 0);
        return retVal;
    }

    public EI getManufacturerIdentifier() {
        EI retVal = (EI)this.getTypedField(7, 0);
        return retVal;
    }

    public EI getItm7_ManufacturerIdentifier() {
        EI retVal = (EI)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getManufacturerName() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getItm8_ManufacturerName() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getManufacturerCatalogNumber() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getItm9_ManufacturerCatalogNumber() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getManufacturerLabelerIdentificationCode() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getItm10_ManufacturerLabelerIdentificationCode() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CNE getPatientChargeableIndicator() {
        CNE retVal = (CNE)this.getTypedField(11, 0);
        return retVal;
    }

    public CNE getItm11_PatientChargeableIndicator() {
        CNE retVal = (CNE)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getTransactionCode() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CWE getItm12_TransactionCode() {
        CWE retVal = (CWE)this.getTypedField(12, 0);
        return retVal;
    }

    public CP getTransactionAmountUnit() {
        CP retVal = (CP)this.getTypedField(13, 0);
        return retVal;
    }

    public CP getItm13_TransactionAmountUnit() {
        CP retVal = (CP)this.getTypedField(13, 0);
        return retVal;
    }

    public CNE getStockedItemIndicator() {
        CNE retVal = (CNE)this.getTypedField(14, 0);
        return retVal;
    }

    public CNE getItm14_StockedItemIndicator() {
        CNE retVal = (CNE)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getSupplyRiskCodes() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getItm15_SupplyRiskCodes() {
        CWE retVal = (CWE)this.getTypedField(15, 0);
        return retVal;
    }

    public XON[] getApprovingRegulatoryAgency() {
        XON[] retVal = (XON[])this.getTypedField(16, (Type[])new XON[0]);
        return retVal;
    }

    public XON[] getItm16_ApprovingRegulatoryAgency() {
        XON[] retVal = (XON[])this.getTypedField(16, (Type[])new XON[0]);
        return retVal;
    }

    public int getApprovingRegulatoryAgencyReps() {
        return this.getReps(16);
    }

    public XON getApprovingRegulatoryAgency(int rep) {
        XON retVal = (XON)this.getTypedField(16, rep);
        return retVal;
    }

    public XON getItm16_ApprovingRegulatoryAgency(int rep) {
        XON retVal = (XON)this.getTypedField(16, rep);
        return retVal;
    }

    public int getItm16_ApprovingRegulatoryAgencyReps() {
        return this.getReps(16);
    }

    public XON insertApprovingRegulatoryAgency(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(16, rep);
    }

    public XON insertItm16_ApprovingRegulatoryAgency(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(16, rep);
    }

    public XON removeApprovingRegulatoryAgency(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(16, rep);
    }

    public XON removeItm16_ApprovingRegulatoryAgency(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(16, rep);
    }

    public CNE getLatexIndicator() {
        CNE retVal = (CNE)this.getTypedField(17, 0);
        return retVal;
    }

    public CNE getItm17_LatexIndicator() {
        CNE retVal = (CNE)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE[] getRulingAct() {
        CWE[] retVal = (CWE[])this.getTypedField(18, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getItm18_RulingAct() {
        CWE[] retVal = (CWE[])this.getTypedField(18, (Type[])new CWE[0]);
        return retVal;
    }

    public int getRulingActReps() {
        return this.getReps(18);
    }

    public CWE getRulingAct(int rep) {
        CWE retVal = (CWE)this.getTypedField(18, rep);
        return retVal;
    }

    public CWE getItm18_RulingAct(int rep) {
        CWE retVal = (CWE)this.getTypedField(18, rep);
        return retVal;
    }

    public int getItm18_RulingActReps() {
        return this.getReps(18);
    }

    public CWE insertRulingAct(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(18, rep);
    }

    public CWE insertItm18_RulingAct(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(18, rep);
    }

    public CWE removeRulingAct(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(18, rep);
    }

    public CWE removeItm18_RulingAct(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(18, rep);
    }

    public IS getItemNaturalAccountCode() {
        IS retVal = (IS)this.getTypedField(19, 0);
        return retVal;
    }

    public IS getItm19_ItemNaturalAccountCode() {
        IS retVal = (IS)this.getTypedField(19, 0);
        return retVal;
    }

    public NM getApprovedToBuyQuantity() {
        NM retVal = (NM)this.getTypedField(20, 0);
        return retVal;
    }

    public NM getItm20_ApprovedToBuyQuantity() {
        NM retVal = (NM)this.getTypedField(20, 0);
        return retVal;
    }

    public MO getApprovedToBuyPrice() {
        MO retVal = (MO)this.getTypedField(21, 0);
        return retVal;
    }

    public MO getItm21_ApprovedToBuyPrice() {
        MO retVal = (MO)this.getTypedField(21, 0);
        return retVal;
    }

    public CNE getTaxableItemIndicator() {
        CNE retVal = (CNE)this.getTypedField(22, 0);
        return retVal;
    }

    public CNE getItm22_TaxableItemIndicator() {
        CNE retVal = (CNE)this.getTypedField(22, 0);
        return retVal;
    }

    public CNE getFreightChargeIndicator() {
        CNE retVal = (CNE)this.getTypedField(23, 0);
        return retVal;
    }

    public CNE getItm23_FreightChargeIndicator() {
        CNE retVal = (CNE)this.getTypedField(23, 0);
        return retVal;
    }

    public CNE getItemSetIndicator() {
        CNE retVal = (CNE)this.getTypedField(24, 0);
        return retVal;
    }

    public CNE getItm24_ItemSetIndicator() {
        CNE retVal = (CNE)this.getTypedField(24, 0);
        return retVal;
    }

    public EI getItemSetIdentifier() {
        EI retVal = (EI)this.getTypedField(25, 0);
        return retVal;
    }

    public EI getItm25_ItemSetIdentifier() {
        EI retVal = (EI)this.getTypedField(25, 0);
        return retVal;
    }

    public CNE getTrackDepartmentUsageIndicator() {
        CNE retVal = (CNE)this.getTypedField(26, 0);
        return retVal;
    }

    public CNE getItm26_TrackDepartmentUsageIndicator() {
        CNE retVal = (CNE)this.getTypedField(26, 0);
        return retVal;
    }

    public CNE getProcedureCode() {
        CNE retVal = (CNE)this.getTypedField(27, 0);
        return retVal;
    }

    public CNE getItm27_ProcedureCode() {
        CNE retVal = (CNE)this.getTypedField(27, 0);
        return retVal;
    }

    public CNE[] getProcedureCodeModifier() {
        CNE[] retVal = (CNE[])this.getTypedField(28, (Type[])new CNE[0]);
        return retVal;
    }

    public CNE[] getItm28_ProcedureCodeModifier() {
        CNE[] retVal = (CNE[])this.getTypedField(28, (Type[])new CNE[0]);
        return retVal;
    }

    public int getProcedureCodeModifierReps() {
        return this.getReps(28);
    }

    public CNE getProcedureCodeModifier(int rep) {
        CNE retVal = (CNE)this.getTypedField(28, rep);
        return retVal;
    }

    public CNE getItm28_ProcedureCodeModifier(int rep) {
        CNE retVal = (CNE)this.getTypedField(28, rep);
        return retVal;
    }

    public int getItm28_ProcedureCodeModifierReps() {
        return this.getReps(28);
    }

    public CNE insertProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(28, rep);
    }

    public CNE insertItm28_ProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(28, rep);
    }

    public CNE removeProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(28, rep);
    }

    public CNE removeItm28_ProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(28, rep);
    }

    public CWE getSpecialHandlingCode() {
        CWE retVal = (CWE)this.getTypedField(29, 0);
        return retVal;
    }

    public CWE getItm29_SpecialHandlingCode() {
        CWE retVal = (CWE)this.getTypedField(29, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CNE(this.getMessage());
            }
            case 6: {
                return new EI(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new CNE(this.getMessage());
            }
            case 11: {
                return new CWE(this.getMessage());
            }
            case 12: {
                return new CP(this.getMessage());
            }
            case 13: {
                return new CNE(this.getMessage());
            }
            case 14: {
                return new CWE(this.getMessage());
            }
            case 15: {
                return new XON(this.getMessage());
            }
            case 16: {
                return new CNE(this.getMessage());
            }
            case 17: {
                return new CWE(this.getMessage());
            }
            case 18: {
                return new IS(this.getMessage(), new Integer(320));
            }
            case 19: {
                return new NM(this.getMessage());
            }
            case 20: {
                return new MO(this.getMessage());
            }
            case 21: {
                return new CNE(this.getMessage());
            }
            case 22: {
                return new CNE(this.getMessage());
            }
            case 23: {
                return new CNE(this.getMessage());
            }
            case 24: {
                return new EI(this.getMessage());
            }
            case 25: {
                return new CNE(this.getMessage());
            }
            case 26: {
                return new CNE(this.getMessage());
            }
            case 27: {
                return new CNE(this.getMessage());
            }
            case 28: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

