/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RQ1
extends AbstractSegment {
    public RQ1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, false, 1, 10, new Object[]{this.getMessage()}, "Anticipated Price");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Manufacturer Identifier");
            this.add(ST.class, false, 1, 16, new Object[]{this.getMessage()}, "Manufacturer's Catalog");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "Vendor ID");
            this.add(ST.class, false, 1, 16, new Object[]{this.getMessage()}, "Vendor Catalog");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Taxable");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Substitute Allowed");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating RQ1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST getAnticipatedPrice() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getRq11_AnticipatedPrice() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getManufacturerIdentifier() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getRq12_ManufacturerIdentifier() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getManufacturerSCatalog() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getRq13_ManufacturerSCatalog() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getVendorID() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getRq14_VendorID() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getVendorCatalog() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getRq15_VendorCatalog() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getTaxable() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getRq16_Taxable() {
        ID retVal = (ID)this.getTypedField(6, 0);
        return retVal;
    }

    public ID getSubstituteAllowed() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getRq17_SubstituteAllowed() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(136));
            }
        }
        return null;
    }
}

