/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.OUL_R23_PATIENT_OBSERVATION;
import ca.uhn.hl7v2.model.v28.group.OUL_R23_VISIT;
import ca.uhn.hl7v2.model.v28.segment.ARV;
import ca.uhn.hl7v2.model.v28.segment.NTE;
import ca.uhn.hl7v2.model.v28.segment.PD1;
import ca.uhn.hl7v2.model.v28.segment.PID;
import ca.uhn.hl7v2.model.v28.segment.PRT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OUL_R23_PATIENT
extends AbstractGroup {
    public OUL_R23_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false, false);
            this.add(PD1.class, false, false, false);
            this.add(PRT.class, false, true, false);
            this.add(ARV.class, false, true, false);
            this.add(NTE.class, false, true, false);
            this.add(OUL_R23_PATIENT_OBSERVATION.class, false, true, false);
            this.add(OUL_R23_VISIT.class, false, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OUL_R23_PATIENT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public PID getPID() {
        PID retVal = (PID)this.getTyped("PID", PID.class);
        return retVal;
    }

    public PD1 getPD1() {
        PD1 retVal = (PD1)this.getTyped("PD1", PD1.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = (PRT)this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public ARV getARV() {
        ARV retVal = (ARV)this.getTyped("ARV", ARV.class);
        return retVal;
    }

    public ARV getARV(int rep) {
        ARV retVal = (ARV)this.getTyped("ARV", rep, ARV.class);
        return retVal;
    }

    public int getARVReps() {
        return this.getReps("ARV");
    }

    public List<ARV> getARVAll() throws HL7Exception {
        return this.getAllAsList("ARV", ARV.class);
    }

    public void insertARV(ARV structure, int rep) throws HL7Exception {
        super.insertRepetition("ARV", (Structure)structure, rep);
    }

    public ARV insertARV(int rep) throws HL7Exception {
        return (ARV)super.insertRepetition("ARV", rep);
    }

    public ARV removeARV(int rep) throws HL7Exception {
        return (ARV)super.removeRepetition("ARV", rep);
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public OUL_R23_PATIENT_OBSERVATION getPATIENT_OBSERVATION() {
        OUL_R23_PATIENT_OBSERVATION retVal = (OUL_R23_PATIENT_OBSERVATION)this.getTyped("PATIENT_OBSERVATION", OUL_R23_PATIENT_OBSERVATION.class);
        return retVal;
    }

    public OUL_R23_PATIENT_OBSERVATION getPATIENT_OBSERVATION(int rep) {
        OUL_R23_PATIENT_OBSERVATION retVal = (OUL_R23_PATIENT_OBSERVATION)this.getTyped("PATIENT_OBSERVATION", rep, OUL_R23_PATIENT_OBSERVATION.class);
        return retVal;
    }

    public int getPATIENT_OBSERVATIONReps() {
        return this.getReps("PATIENT_OBSERVATION");
    }

    public List<OUL_R23_PATIENT_OBSERVATION> getPATIENT_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("PATIENT_OBSERVATION", OUL_R23_PATIENT_OBSERVATION.class);
    }

    public void insertPATIENT_OBSERVATION(OUL_R23_PATIENT_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT_OBSERVATION", (Structure)structure, rep);
    }

    public OUL_R23_PATIENT_OBSERVATION insertPATIENT_OBSERVATION(int rep) throws HL7Exception {
        return (OUL_R23_PATIENT_OBSERVATION)super.insertRepetition("PATIENT_OBSERVATION", rep);
    }

    public OUL_R23_PATIENT_OBSERVATION removePATIENT_OBSERVATION(int rep) throws HL7Exception {
        return (OUL_R23_PATIENT_OBSERVATION)super.removeRepetition("PATIENT_OBSERVATION", rep);
    }

    public OUL_R23_VISIT getVISIT() {
        OUL_R23_VISIT retVal = (OUL_R23_VISIT)this.getTyped("VISIT", OUL_R23_VISIT.class);
        return retVal;
    }
}

