/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.PPP_PCB_GOAL_OBSERVATION;
import ca.uhn.hl7v2.model.v28.group.PPP_PCB_GOAL_ROLE;
import ca.uhn.hl7v2.model.v28.segment.GOL;
import ca.uhn.hl7v2.model.v28.segment.NTE;
import ca.uhn.hl7v2.model.v28.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class PPP_PCB_GOAL
extends AbstractGroup {
    public PPP_PCB_GOAL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(GOL.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(VAR.class, false, true, false);
            this.add(PPP_PCB_GOAL_ROLE.class, false, true, false);
            this.add(PPP_PCB_GOAL_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PPP_PCB_GOAL - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public GOL getGOL() {
        GOL retVal = (GOL)this.getTyped("GOL", GOL.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public VAR getVAR() {
        VAR retVal = (VAR)this.getTyped("VAR", VAR.class);
        return retVal;
    }

    public VAR getVAR(int rep) {
        VAR retVal = (VAR)this.getTyped("VAR", rep, VAR.class);
        return retVal;
    }

    public int getVARReps() {
        return this.getReps("VAR");
    }

    public List<VAR> getVARAll() throws HL7Exception {
        return this.getAllAsList("VAR", VAR.class);
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", (Structure)structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public PPP_PCB_GOAL_ROLE getGOAL_ROLE() {
        PPP_PCB_GOAL_ROLE retVal = (PPP_PCB_GOAL_ROLE)this.getTyped("GOAL_ROLE", PPP_PCB_GOAL_ROLE.class);
        return retVal;
    }

    public PPP_PCB_GOAL_ROLE getGOAL_ROLE(int rep) {
        PPP_PCB_GOAL_ROLE retVal = (PPP_PCB_GOAL_ROLE)this.getTyped("GOAL_ROLE", rep, PPP_PCB_GOAL_ROLE.class);
        return retVal;
    }

    public int getGOAL_ROLEReps() {
        return this.getReps("GOAL_ROLE");
    }

    public List<PPP_PCB_GOAL_ROLE> getGOAL_ROLEAll() throws HL7Exception {
        return this.getAllAsList("GOAL_ROLE", PPP_PCB_GOAL_ROLE.class);
    }

    public void insertGOAL_ROLE(PPP_PCB_GOAL_ROLE structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL_ROLE", (Structure)structure, rep);
    }

    public PPP_PCB_GOAL_ROLE insertGOAL_ROLE(int rep) throws HL7Exception {
        return (PPP_PCB_GOAL_ROLE)super.insertRepetition("GOAL_ROLE", rep);
    }

    public PPP_PCB_GOAL_ROLE removeGOAL_ROLE(int rep) throws HL7Exception {
        return (PPP_PCB_GOAL_ROLE)super.removeRepetition("GOAL_ROLE", rep);
    }

    public PPP_PCB_GOAL_OBSERVATION getGOAL_OBSERVATION() {
        PPP_PCB_GOAL_OBSERVATION retVal = (PPP_PCB_GOAL_OBSERVATION)this.getTyped("GOAL_OBSERVATION", PPP_PCB_GOAL_OBSERVATION.class);
        return retVal;
    }

    public PPP_PCB_GOAL_OBSERVATION getGOAL_OBSERVATION(int rep) {
        PPP_PCB_GOAL_OBSERVATION retVal = (PPP_PCB_GOAL_OBSERVATION)this.getTyped("GOAL_OBSERVATION", rep, PPP_PCB_GOAL_OBSERVATION.class);
        return retVal;
    }

    public int getGOAL_OBSERVATIONReps() {
        return this.getReps("GOAL_OBSERVATION");
    }

    public List<PPP_PCB_GOAL_OBSERVATION> getGOAL_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("GOAL_OBSERVATION", PPP_PCB_GOAL_OBSERVATION.class);
    }

    public void insertGOAL_OBSERVATION(PPP_PCB_GOAL_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL_OBSERVATION", (Structure)structure, rep);
    }

    public PPP_PCB_GOAL_OBSERVATION insertGOAL_OBSERVATION(int rep) throws HL7Exception {
        return (PPP_PCB_GOAL_OBSERVATION)super.insertRepetition("GOAL_OBSERVATION", rep);
    }

    public PPP_PCB_GOAL_OBSERVATION removeGOAL_OBSERVATION(int rep) throws HL7Exception {
        return (PPP_PCB_GOAL_OBSERVATION)super.removeRepetition("GOAL_OBSERVATION", rep);
    }
}

