/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.DFT_P03_FINANCIAL_COMMON_ORDER;
import ca.uhn.hl7v2.model.v28.group.DFT_P03_FINANCIAL_PROCEDURE;
import ca.uhn.hl7v2.model.v28.segment.FT1;
import ca.uhn.hl7v2.model.v28.segment.NTE;
import ca.uhn.hl7v2.model.v28.segment.PRT;
import ca.uhn.hl7v2.model.v28.segment.ROL;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class DFT_P03_FINANCIAL
extends AbstractGroup {
    public DFT_P03_FINANCIAL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(FT1.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(ROL.class, false, true, false);
            this.add(NTE.class, false, false, false);
            this.add(DFT_P03_FINANCIAL_PROCEDURE.class, false, true, false);
            this.add(DFT_P03_FINANCIAL_COMMON_ORDER.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DFT_P03_FINANCIAL - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public FT1 getFT1() {
        FT1 retVal = (FT1)this.getTyped("FT1", FT1.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = (PRT)this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public ROL getROL() {
        ROL retVal = (ROL)this.getTyped("ROL", ROL.class);
        return retVal;
    }

    public ROL getROL(int rep) {
        ROL retVal = (ROL)this.getTyped("ROL", rep, ROL.class);
        return retVal;
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", (Structure)structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public DFT_P03_FINANCIAL_PROCEDURE getFINANCIAL_PROCEDURE() {
        DFT_P03_FINANCIAL_PROCEDURE retVal = (DFT_P03_FINANCIAL_PROCEDURE)this.getTyped("FINANCIAL_PROCEDURE", DFT_P03_FINANCIAL_PROCEDURE.class);
        return retVal;
    }

    public DFT_P03_FINANCIAL_PROCEDURE getFINANCIAL_PROCEDURE(int rep) {
        DFT_P03_FINANCIAL_PROCEDURE retVal = (DFT_P03_FINANCIAL_PROCEDURE)this.getTyped("FINANCIAL_PROCEDURE", rep, DFT_P03_FINANCIAL_PROCEDURE.class);
        return retVal;
    }

    public int getFINANCIAL_PROCEDUREReps() {
        return this.getReps("FINANCIAL_PROCEDURE");
    }

    public List<DFT_P03_FINANCIAL_PROCEDURE> getFINANCIAL_PROCEDUREAll() throws HL7Exception {
        return this.getAllAsList("FINANCIAL_PROCEDURE", DFT_P03_FINANCIAL_PROCEDURE.class);
    }

    public void insertFINANCIAL_PROCEDURE(DFT_P03_FINANCIAL_PROCEDURE structure, int rep) throws HL7Exception {
        super.insertRepetition("FINANCIAL_PROCEDURE", (Structure)structure, rep);
    }

    public DFT_P03_FINANCIAL_PROCEDURE insertFINANCIAL_PROCEDURE(int rep) throws HL7Exception {
        return (DFT_P03_FINANCIAL_PROCEDURE)super.insertRepetition("FINANCIAL_PROCEDURE", rep);
    }

    public DFT_P03_FINANCIAL_PROCEDURE removeFINANCIAL_PROCEDURE(int rep) throws HL7Exception {
        return (DFT_P03_FINANCIAL_PROCEDURE)super.removeRepetition("FINANCIAL_PROCEDURE", rep);
    }

    public DFT_P03_FINANCIAL_COMMON_ORDER getFINANCIAL_COMMON_ORDER() {
        DFT_P03_FINANCIAL_COMMON_ORDER retVal = (DFT_P03_FINANCIAL_COMMON_ORDER)this.getTyped("FINANCIAL_COMMON_ORDER", DFT_P03_FINANCIAL_COMMON_ORDER.class);
        return retVal;
    }

    public DFT_P03_FINANCIAL_COMMON_ORDER getFINANCIAL_COMMON_ORDER(int rep) {
        DFT_P03_FINANCIAL_COMMON_ORDER retVal = (DFT_P03_FINANCIAL_COMMON_ORDER)this.getTyped("FINANCIAL_COMMON_ORDER", rep, DFT_P03_FINANCIAL_COMMON_ORDER.class);
        return retVal;
    }

    public int getFINANCIAL_COMMON_ORDERReps() {
        return this.getReps("FINANCIAL_COMMON_ORDER");
    }

    public List<DFT_P03_FINANCIAL_COMMON_ORDER> getFINANCIAL_COMMON_ORDERAll() throws HL7Exception {
        return this.getAllAsList("FINANCIAL_COMMON_ORDER", DFT_P03_FINANCIAL_COMMON_ORDER.class);
    }

    public void insertFINANCIAL_COMMON_ORDER(DFT_P03_FINANCIAL_COMMON_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("FINANCIAL_COMMON_ORDER", (Structure)structure, rep);
    }

    public DFT_P03_FINANCIAL_COMMON_ORDER insertFINANCIAL_COMMON_ORDER(int rep) throws HL7Exception {
        return (DFT_P03_FINANCIAL_COMMON_ORDER)super.insertRepetition("FINANCIAL_COMMON_ORDER", rep);
    }

    public DFT_P03_FINANCIAL_COMMON_ORDER removeFINANCIAL_COMMON_ORDER(int rep) throws HL7Exception {
        return (DFT_P03_FINANCIAL_COMMON_ORDER)super.removeRepetition("FINANCIAL_COMMON_ORDER", rep);
    }
}

