/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.segment.DON;
import ca.uhn.hl7v2.model.v28.segment.NTE;
import ca.uhn.hl7v2.model.v28.segment.OBX;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RSP_O34_DONATION
extends AbstractGroup {
    public RSP_O34_DONATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(DON.class, true, false, false);
            this.add(OBX.class, false, true, false);
            this.add(NTE.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RSP_O34_DONATION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public DON getDON() {
        DON retVal = (DON)this.getTyped("DON", DON.class);
        return retVal;
    }

    public OBX getOBX() {
        OBX retVal = (OBX)this.getTyped("OBX", OBX.class);
        return retVal;
    }

    public OBX getOBX(int rep) {
        OBX retVal = (OBX)this.getTyped("OBX", rep, OBX.class);
        return retVal;
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", (Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

