/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.DPR_O48_DONATION;
import ca.uhn.hl7v2.model.v28.group.DPR_O48_DONATION_ORDER;
import ca.uhn.hl7v2.model.v28.group.DPR_O48_DONOR;
import ca.uhn.hl7v2.model.v28.segment.MSH;
import ca.uhn.hl7v2.model.v28.segment.SFT;
import ca.uhn.hl7v2.model.v28.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class DPR_O48
extends AbstractMessage {
    public DPR_O48() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public DPR_O48(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(DPR_O48_DONOR.class, false, false);
            this.add(DPR_O48_DONATION_ORDER.class, true, true);
            this.add(DPR_O48_DONATION.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DPR_O48 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public DPR_O48_DONOR getDONOR() {
        return (DPR_O48_DONOR)this.getTyped("DONOR", DPR_O48_DONOR.class);
    }

    public DPR_O48_DONATION_ORDER getDONATION_ORDER() {
        return (DPR_O48_DONATION_ORDER)this.getTyped("DONATION_ORDER", DPR_O48_DONATION_ORDER.class);
    }

    public DPR_O48_DONATION_ORDER getDONATION_ORDER(int rep) {
        return (DPR_O48_DONATION_ORDER)this.getTyped("DONATION_ORDER", rep, DPR_O48_DONATION_ORDER.class);
    }

    public int getDONATION_ORDERReps() {
        return this.getReps("DONATION_ORDER");
    }

    public List<DPR_O48_DONATION_ORDER> getDONATION_ORDERAll() throws HL7Exception {
        return this.getAllAsList("DONATION_ORDER", DPR_O48_DONATION_ORDER.class);
    }

    public void insertDONATION_ORDER(DPR_O48_DONATION_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("DONATION_ORDER", (Structure)structure, rep);
    }

    public DPR_O48_DONATION_ORDER insertDONATION_ORDER(int rep) throws HL7Exception {
        return (DPR_O48_DONATION_ORDER)super.insertRepetition("DONATION_ORDER", rep);
    }

    public DPR_O48_DONATION_ORDER removeDONATION_ORDER(int rep) throws HL7Exception {
        return (DPR_O48_DONATION_ORDER)super.removeRepetition("DONATION_ORDER", rep);
    }

    public DPR_O48_DONATION getDONATION() {
        return (DPR_O48_DONATION)this.getTyped("DONATION", DPR_O48_DONATION.class);
    }
}

