/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v28.group.OSM_R26_SHIPMENT;
import ca.uhn.hl7v2.model.v28.segment.MSH;
import ca.uhn.hl7v2.model.v28.segment.SFT;
import ca.uhn.hl7v2.model.v28.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OSM_R26
extends AbstractMessage {
    public OSM_R26() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public OSM_R26(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(OSM_R26_SHIPMENT.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OSM_R26 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public OSM_R26_SHIPMENT getSHIPMENT() {
        return (OSM_R26_SHIPMENT)this.getTyped("SHIPMENT", OSM_R26_SHIPMENT.class);
    }

    public OSM_R26_SHIPMENT getSHIPMENT(int rep) {
        return (OSM_R26_SHIPMENT)this.getTyped("SHIPMENT", rep, OSM_R26_SHIPMENT.class);
    }

    public int getSHIPMENTReps() {
        return this.getReps("SHIPMENT");
    }

    public List<OSM_R26_SHIPMENT> getSHIPMENTAll() throws HL7Exception {
        return this.getAllAsList("SHIPMENT", OSM_R26_SHIPMENT.class);
    }

    public void insertSHIPMENT(OSM_R26_SHIPMENT structure, int rep) throws HL7Exception {
        super.insertRepetition("SHIPMENT", (Structure)structure, rep);
    }

    public OSM_R26_SHIPMENT insertSHIPMENT(int rep) throws HL7Exception {
        return (OSM_R26_SHIPMENT)super.insertRepetition("SHIPMENT", rep);
    }

    public OSM_R26_SHIPMENT removeSHIPMENT(int rep) throws HL7Exception {
        return (OSM_R26_SHIPMENT)super.removeRepetition("SHIPMENT", rep);
    }
}

