/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CNE;
import ca.uhn.hl7v2.model.v28.datatype.NM;
import ca.uhn.hl7v2.model.v28.datatype.NR;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class DMI
extends AbstractSegment {
    public DMI(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Diagnostic Related Group");
            this.add(CNE.class, false, 1, 0, new Object[]{this.getMessage()}, "Major Diagnostic Category");
            this.add(NR.class, false, 1, 0, new Object[]{this.getMessage()}, "Lower and Upper Trim Points");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Average Length of Stay");
            this.add(NM.class, false, 1, 0, new Object[]{this.getMessage()}, "Relative Weight");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DMI - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CNE getDiagnosticRelatedGroup() {
        CNE retVal = (CNE)this.getTypedField(1, 0);
        return retVal;
    }

    public CNE getDmi1_DiagnosticRelatedGroup() {
        CNE retVal = (CNE)this.getTypedField(1, 0);
        return retVal;
    }

    public CNE getMajorDiagnosticCategory() {
        CNE retVal = (CNE)this.getTypedField(2, 0);
        return retVal;
    }

    public CNE getDmi2_MajorDiagnosticCategory() {
        CNE retVal = (CNE)this.getTypedField(2, 0);
        return retVal;
    }

    public NR getLowerAndUpperTrimPoints() {
        NR retVal = (NR)this.getTypedField(3, 0);
        return retVal;
    }

    public NR getDmi3_LowerAndUpperTrimPoints() {
        NR retVal = (NR)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getAverageLengthOfStay() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getDmi4_AverageLengthOfStay() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getRelativeWeight() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getDmi5_RelativeWeight() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CNE(this.getMessage());
            }
            case 1: {
                return new CNE(this.getMessage());
            }
            case 2: {
                return new NR(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new NM(this.getMessage());
            }
        }
        return null;
    }
}

