/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v28.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v28.datatype.CWE;
import ca.uhn.hl7v2.model.v28.datatype.NM;
import ca.uhn.hl7v2.model.v28.datatype.OCD;
import ca.uhn.hl7v2.model.v28.datatype.OSP;
import ca.uhn.hl7v2.model.v28.datatype.SI;
import ca.uhn.hl7v2.model.v28.datatype.ST;
import ca.uhn.hl7v2.model.v28.datatype.UVC;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class UB2
extends AbstractSegment {
    public UB2(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - UB2");
            this.add(ST.class, false, 1, 3, new Object[]{this.getMessage()}, "Co-Insurance Days (9)");
            this.add(CWE.class, false, 7, 0, new Object[]{this.getMessage()}, "Condition Code (24-30)");
            this.add(ST.class, false, 1, 3, new Object[]{this.getMessage()}, "Covered Days (7)");
            this.add(ST.class, false, 1, 4, new Object[]{this.getMessage()}, "Non-Covered Days (8)");
            this.add(UVC.class, false, 12, 0, new Object[]{this.getMessage()}, "Value Amount & Code (39-41)");
            this.add(OCD.class, false, 8, 0, new Object[]{this.getMessage()}, "Occurrence Code & Date (32-35)");
            this.add(OSP.class, false, 2, 0, new Object[]{this.getMessage()}, "Occurrence Span Code/Dates (36)");
            this.add(ST.class, false, 2, 29, new Object[]{this.getMessage()}, "Uniform Billing Locator 2 (state)");
            this.add(ST.class, false, 2, 12, new Object[]{this.getMessage()}, "Uniform Billing Locator 11 (state)");
            this.add(ST.class, false, 1, 5, new Object[]{this.getMessage()}, "Uniform Billing Locator 31 (national)");
            this.add(ST.class, false, 3, 23, new Object[]{this.getMessage()}, "Document Control Number");
            this.add(ST.class, false, 23, 4, new Object[]{this.getMessage()}, "Uniform Billing Locator 49 (national)");
            this.add(ST.class, false, 5, 14, new Object[]{this.getMessage()}, "Uniform Billing Locator 56 (state)");
            this.add(ST.class, false, 1, 27, new Object[]{this.getMessage()}, "Uniform Billing Locator 57 (sational)");
            this.add(ST.class, false, 2, 2, new Object[]{this.getMessage()}, "Uniform Billing Locator 78 (state)");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "Special Visit Count");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating UB2 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDUB2() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getUb21_SetIDUB2() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getCoInsuranceDays9() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getUb22_CoInsuranceDays9() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE[] getConditionCode2430() {
        CWE[] retVal = (CWE[])this.getTypedField(3, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getUb23_ConditionCode2430() {
        CWE[] retVal = (CWE[])this.getTypedField(3, (Type[])new CWE[0]);
        return retVal;
    }

    public int getConditionCode2430Reps() {
        return this.getReps(3);
    }

    public CWE getConditionCode2430(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public CWE getUb23_ConditionCode2430(int rep) {
        CWE retVal = (CWE)this.getTypedField(3, rep);
        return retVal;
    }

    public int getUb23_ConditionCode2430Reps() {
        return this.getReps(3);
    }

    public CWE insertConditionCode2430(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE insertUb23_ConditionCode2430(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(3, rep);
    }

    public CWE removeConditionCode2430(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public CWE removeUb23_ConditionCode2430(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(3, rep);
    }

    public ST getCoveredDays7() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getUb24_CoveredDays7() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getNonCoveredDays8() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public ST getUb25_NonCoveredDays8() {
        ST retVal = (ST)this.getTypedField(5, 0);
        return retVal;
    }

    public UVC[] getValueAmountCode3941() {
        UVC[] retVal = (UVC[])this.getTypedField(6, (Type[])new UVC[0]);
        return retVal;
    }

    public UVC[] getUb26_ValueAmountCode3941() {
        UVC[] retVal = (UVC[])this.getTypedField(6, (Type[])new UVC[0]);
        return retVal;
    }

    public int getValueAmountCode3941Reps() {
        return this.getReps(6);
    }

    public UVC getValueAmountCode3941(int rep) {
        UVC retVal = (UVC)this.getTypedField(6, rep);
        return retVal;
    }

    public UVC getUb26_ValueAmountCode3941(int rep) {
        UVC retVal = (UVC)this.getTypedField(6, rep);
        return retVal;
    }

    public int getUb26_ValueAmountCode3941Reps() {
        return this.getReps(6);
    }

    public UVC insertValueAmountCode3941(int rep) throws HL7Exception {
        return (UVC)super.insertRepetition(6, rep);
    }

    public UVC insertUb26_ValueAmountCode3941(int rep) throws HL7Exception {
        return (UVC)super.insertRepetition(6, rep);
    }

    public UVC removeValueAmountCode3941(int rep) throws HL7Exception {
        return (UVC)super.removeRepetition(6, rep);
    }

    public UVC removeUb26_ValueAmountCode3941(int rep) throws HL7Exception {
        return (UVC)super.removeRepetition(6, rep);
    }

    public OCD[] getOccurrenceCodeDate3235() {
        OCD[] retVal = (OCD[])this.getTypedField(7, (Type[])new OCD[0]);
        return retVal;
    }

    public OCD[] getUb27_OccurrenceCodeDate3235() {
        OCD[] retVal = (OCD[])this.getTypedField(7, (Type[])new OCD[0]);
        return retVal;
    }

    public int getOccurrenceCodeDate3235Reps() {
        return this.getReps(7);
    }

    public OCD getOccurrenceCodeDate3235(int rep) {
        OCD retVal = (OCD)this.getTypedField(7, rep);
        return retVal;
    }

    public OCD getUb27_OccurrenceCodeDate3235(int rep) {
        OCD retVal = (OCD)this.getTypedField(7, rep);
        return retVal;
    }

    public int getUb27_OccurrenceCodeDate3235Reps() {
        return this.getReps(7);
    }

    public OCD insertOccurrenceCodeDate3235(int rep) throws HL7Exception {
        return (OCD)super.insertRepetition(7, rep);
    }

    public OCD insertUb27_OccurrenceCodeDate3235(int rep) throws HL7Exception {
        return (OCD)super.insertRepetition(7, rep);
    }

    public OCD removeOccurrenceCodeDate3235(int rep) throws HL7Exception {
        return (OCD)super.removeRepetition(7, rep);
    }

    public OCD removeUb27_OccurrenceCodeDate3235(int rep) throws HL7Exception {
        return (OCD)super.removeRepetition(7, rep);
    }

    public OSP[] getOccurrenceSpanCodeDates() {
        OSP[] retVal = (OSP[])this.getTypedField(8, (Type[])new OSP[0]);
        return retVal;
    }

    public OSP[] getUb28_OccurrenceSpanCodeDates() {
        OSP[] retVal = (OSP[])this.getTypedField(8, (Type[])new OSP[0]);
        return retVal;
    }

    public int getOccurrenceSpanCodeDatesReps() {
        return this.getReps(8);
    }

    public OSP getOccurrenceSpanCodeDates(int rep) {
        OSP retVal = (OSP)this.getTypedField(8, rep);
        return retVal;
    }

    public OSP getUb28_OccurrenceSpanCodeDates(int rep) {
        OSP retVal = (OSP)this.getTypedField(8, rep);
        return retVal;
    }

    public int getUb28_OccurrenceSpanCodeDatesReps() {
        return this.getReps(8);
    }

    public OSP insertOccurrenceSpanCodeDates(int rep) throws HL7Exception {
        return (OSP)super.insertRepetition(8, rep);
    }

    public OSP insertUb28_OccurrenceSpanCodeDates(int rep) throws HL7Exception {
        return (OSP)super.insertRepetition(8, rep);
    }

    public OSP removeOccurrenceSpanCodeDates(int rep) throws HL7Exception {
        return (OSP)super.removeRepetition(8, rep);
    }

    public OSP removeUb28_OccurrenceSpanCodeDates(int rep) throws HL7Exception {
        return (OSP)super.removeRepetition(8, rep);
    }

    public ST[] getUniformBillingLocator2State() {
        ST[] retVal = (ST[])this.getTypedField(9, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getUb29_UniformBillingLocator2State() {
        ST[] retVal = (ST[])this.getTypedField(9, (Type[])new ST[0]);
        return retVal;
    }

    public int getUniformBillingLocator2StateReps() {
        return this.getReps(9);
    }

    public ST getUniformBillingLocator2State(int rep) {
        ST retVal = (ST)this.getTypedField(9, rep);
        return retVal;
    }

    public ST getUb29_UniformBillingLocator2State(int rep) {
        ST retVal = (ST)this.getTypedField(9, rep);
        return retVal;
    }

    public int getUb29_UniformBillingLocator2StateReps() {
        return this.getReps(9);
    }

    public ST insertUniformBillingLocator2State(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(9, rep);
    }

    public ST insertUb29_UniformBillingLocator2State(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(9, rep);
    }

    public ST removeUniformBillingLocator2State(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(9, rep);
    }

    public ST removeUb29_UniformBillingLocator2State(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(9, rep);
    }

    public ST[] getUniformBillingLocator11State() {
        ST[] retVal = (ST[])this.getTypedField(10, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getUb210_UniformBillingLocator11State() {
        ST[] retVal = (ST[])this.getTypedField(10, (Type[])new ST[0]);
        return retVal;
    }

    public int getUniformBillingLocator11StateReps() {
        return this.getReps(10);
    }

    public ST getUniformBillingLocator11State(int rep) {
        ST retVal = (ST)this.getTypedField(10, rep);
        return retVal;
    }

    public ST getUb210_UniformBillingLocator11State(int rep) {
        ST retVal = (ST)this.getTypedField(10, rep);
        return retVal;
    }

    public int getUb210_UniformBillingLocator11StateReps() {
        return this.getReps(10);
    }

    public ST insertUniformBillingLocator11State(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(10, rep);
    }

    public ST insertUb210_UniformBillingLocator11State(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(10, rep);
    }

    public ST removeUniformBillingLocator11State(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(10, rep);
    }

    public ST removeUb210_UniformBillingLocator11State(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(10, rep);
    }

    public ST getUniformBillingLocator31National() {
        ST retVal = (ST)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getUb211_UniformBillingLocator31National() {
        ST retVal = (ST)this.getTypedField(11, 0);
        return retVal;
    }

    public ST[] getDocumentControlNumber() {
        ST[] retVal = (ST[])this.getTypedField(12, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getUb212_DocumentControlNumber() {
        ST[] retVal = (ST[])this.getTypedField(12, (Type[])new ST[0]);
        return retVal;
    }

    public int getDocumentControlNumberReps() {
        return this.getReps(12);
    }

    public ST getDocumentControlNumber(int rep) {
        ST retVal = (ST)this.getTypedField(12, rep);
        return retVal;
    }

    public ST getUb212_DocumentControlNumber(int rep) {
        ST retVal = (ST)this.getTypedField(12, rep);
        return retVal;
    }

    public int getUb212_DocumentControlNumberReps() {
        return this.getReps(12);
    }

    public ST insertDocumentControlNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(12, rep);
    }

    public ST insertUb212_DocumentControlNumber(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(12, rep);
    }

    public ST removeDocumentControlNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(12, rep);
    }

    public ST removeUb212_DocumentControlNumber(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(12, rep);
    }

    public ST[] getUniformBillingLocator49National() {
        ST[] retVal = (ST[])this.getTypedField(13, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getUb213_UniformBillingLocator49National() {
        ST[] retVal = (ST[])this.getTypedField(13, (Type[])new ST[0]);
        return retVal;
    }

    public int getUniformBillingLocator49NationalReps() {
        return this.getReps(13);
    }

    public ST getUniformBillingLocator49National(int rep) {
        ST retVal = (ST)this.getTypedField(13, rep);
        return retVal;
    }

    public ST getUb213_UniformBillingLocator49National(int rep) {
        ST retVal = (ST)this.getTypedField(13, rep);
        return retVal;
    }

    public int getUb213_UniformBillingLocator49NationalReps() {
        return this.getReps(13);
    }

    public ST insertUniformBillingLocator49National(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(13, rep);
    }

    public ST insertUb213_UniformBillingLocator49National(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(13, rep);
    }

    public ST removeUniformBillingLocator49National(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(13, rep);
    }

    public ST removeUb213_UniformBillingLocator49National(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(13, rep);
    }

    public ST[] getUniformBillingLocator56State() {
        ST[] retVal = (ST[])this.getTypedField(14, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getUb214_UniformBillingLocator56State() {
        ST[] retVal = (ST[])this.getTypedField(14, (Type[])new ST[0]);
        return retVal;
    }

    public int getUniformBillingLocator56StateReps() {
        return this.getReps(14);
    }

    public ST getUniformBillingLocator56State(int rep) {
        ST retVal = (ST)this.getTypedField(14, rep);
        return retVal;
    }

    public ST getUb214_UniformBillingLocator56State(int rep) {
        ST retVal = (ST)this.getTypedField(14, rep);
        return retVal;
    }

    public int getUb214_UniformBillingLocator56StateReps() {
        return this.getReps(14);
    }

    public ST insertUniformBillingLocator56State(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(14, rep);
    }

    public ST insertUb214_UniformBillingLocator56State(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(14, rep);
    }

    public ST removeUniformBillingLocator56State(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(14, rep);
    }

    public ST removeUb214_UniformBillingLocator56State(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(14, rep);
    }

    public ST getUniformBillingLocator57Sational() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public ST getUb215_UniformBillingLocator57Sational() {
        ST retVal = (ST)this.getTypedField(15, 0);
        return retVal;
    }

    public ST[] getUniformBillingLocator78State() {
        ST[] retVal = (ST[])this.getTypedField(16, (Type[])new ST[0]);
        return retVal;
    }

    public ST[] getUb216_UniformBillingLocator78State() {
        ST[] retVal = (ST[])this.getTypedField(16, (Type[])new ST[0]);
        return retVal;
    }

    public int getUniformBillingLocator78StateReps() {
        return this.getReps(16);
    }

    public ST getUniformBillingLocator78State(int rep) {
        ST retVal = (ST)this.getTypedField(16, rep);
        return retVal;
    }

    public ST getUb216_UniformBillingLocator78State(int rep) {
        ST retVal = (ST)this.getTypedField(16, rep);
        return retVal;
    }

    public int getUb216_UniformBillingLocator78StateReps() {
        return this.getReps(16);
    }

    public ST insertUniformBillingLocator78State(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(16, rep);
    }

    public ST insertUb216_UniformBillingLocator78State(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(16, rep);
    }

    public ST removeUniformBillingLocator78State(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(16, rep);
    }

    public ST removeUb216_UniformBillingLocator78State(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(16, rep);
    }

    public NM getSpecialVisitCount() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    public NM getUb217_SpecialVisitCount() {
        NM retVal = (NM)this.getTypedField(17, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new UVC(this.getMessage());
            }
            case 6: {
                return new OCD(this.getMessage());
            }
            case 7: {
                return new OSP(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new ST(this.getMessage());
            }
            case 10: {
                return new ST(this.getMessage());
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new ST(this.getMessage());
            }
            case 13: {
                return new ST(this.getMessage());
            }
            case 14: {
                return new ST(this.getMessage());
            }
            case 15: {
                return new ST(this.getMessage());
            }
            case 16: {
                return new NM(this.getMessage());
            }
        }
        return null;
    }
}

