/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.DTM;
import ca.uhn.hl7v2.model.v281.datatype.FN;
import ca.uhn.hl7v2.model.v281.datatype.ID;
import ca.uhn.hl7v2.model.v281.datatype.ST;

public class XPN
extends AbstractComposite {
    private Type[] data;

    public XPN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[15];
        this.data[0] = new FN(this.getMessage());
        this.data[1] = new ST(this.getMessage());
        this.data[2] = new ST(this.getMessage());
        this.data[3] = new ST(this.getMessage());
        this.data[4] = new ST(this.getMessage());
        this.data[5] = new ST(this.getMessage());
        this.data[6] = new ID(this.getMessage(), 200);
        this.data[7] = new ID(this.getMessage(), 465);
        this.data[8] = new CWE(this.getMessage());
        this.data[9] = new ST(this.getMessage());
        this.data[10] = new ID(this.getMessage(), 444);
        this.data[11] = new DTM(this.getMessage());
        this.data[12] = new DTM(this.getMessage());
        this.data[13] = new ST(this.getMessage());
        this.data[14] = new ST(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public FN getFamilyName() {
        return (FN)this.getTyped(0, FN.class);
    }

    public FN getXpn1_FamilyName() {
        return (FN)this.getTyped(0, FN.class);
    }

    public ST getGivenName() {
        return (ST)this.getTyped(1, ST.class);
    }

    public ST getXpn2_GivenName() {
        return (ST)this.getTyped(1, ST.class);
    }

    public ST getSecondAndFurtherGivenNamesOrInitialsThereof() {
        return (ST)this.getTyped(2, ST.class);
    }

    public ST getXpn3_SecondAndFurtherGivenNamesOrInitialsThereof() {
        return (ST)this.getTyped(2, ST.class);
    }

    public ST getSuffixEgJRorIII() {
        return (ST)this.getTyped(3, ST.class);
    }

    public ST getXpn4_SuffixEgJRorIII() {
        return (ST)this.getTyped(3, ST.class);
    }

    public ST getPrefixEgDR() {
        return (ST)this.getTyped(4, ST.class);
    }

    public ST getXpn5_PrefixEgDR() {
        return (ST)this.getTyped(4, ST.class);
    }

    public ST getDegreeEgMD() {
        return (ST)this.getTyped(5, ST.class);
    }

    public ST getXpn6_DegreeEgMD() {
        return (ST)this.getTyped(5, ST.class);
    }

    public ID getNameTypeCode() {
        return (ID)this.getTyped(6, ID.class);
    }

    public ID getXpn7_NameTypeCode() {
        return (ID)this.getTyped(6, ID.class);
    }

    public ID getNameRepresentationCode() {
        return (ID)this.getTyped(7, ID.class);
    }

    public ID getXpn8_NameRepresentationCode() {
        return (ID)this.getTyped(7, ID.class);
    }

    public CWE getNameContext() {
        return (CWE)this.getTyped(8, CWE.class);
    }

    public CWE getXpn9_NameContext() {
        return (CWE)this.getTyped(8, CWE.class);
    }

    public ST getNameValidityRange() {
        return (ST)this.getTyped(9, ST.class);
    }

    public ST getXpn10_NameValidityRange() {
        return (ST)this.getTyped(9, ST.class);
    }

    public ID getNameAssemblyOrder() {
        return (ID)this.getTyped(10, ID.class);
    }

    public ID getXpn11_NameAssemblyOrder() {
        return (ID)this.getTyped(10, ID.class);
    }

    public DTM getEffectiveDate() {
        return (DTM)this.getTyped(11, DTM.class);
    }

    public DTM getXpn12_EffectiveDate() {
        return (DTM)this.getTyped(11, DTM.class);
    }

    public DTM getExpirationDate() {
        return (DTM)this.getTyped(12, DTM.class);
    }

    public DTM getXpn13_ExpirationDate() {
        return (DTM)this.getTyped(12, DTM.class);
    }

    public ST getProfessionalSuffix() {
        return (ST)this.getTyped(13, ST.class);
    }

    public ST getXpn14_ProfessionalSuffix() {
        return (ST)this.getTyped(13, ST.class);
    }

    public ST getCalledBy() {
        return (ST)this.getTyped(14, ST.class);
    }

    public ST getXpn15_CalledBy() {
        return (ST)this.getTyped(14, ST.class);
    }
}

