/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v281.datatype.CWE;
import ca.uhn.hl7v2.model.v281.datatype.DTM;
import ca.uhn.hl7v2.model.v281.datatype.EI;
import ca.uhn.hl7v2.model.v281.datatype.ID;
import ca.uhn.hl7v2.model.v281.datatype.NM;
import ca.uhn.hl7v2.model.v281.datatype.SNM;
import ca.uhn.hl7v2.model.v281.datatype.ST;

public class XTN
extends AbstractComposite {
    private Type[] data;

    public XTN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[18];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new ID(this.getMessage(), 201);
        this.data[2] = new ID(this.getMessage(), 202);
        this.data[3] = new ST(this.getMessage());
        this.data[4] = new SNM(this.getMessage());
        this.data[5] = new SNM(this.getMessage());
        this.data[6] = new SNM(this.getMessage());
        this.data[7] = new SNM(this.getMessage());
        this.data[8] = new ST(this.getMessage());
        this.data[9] = new ST(this.getMessage());
        this.data[10] = new ST(this.getMessage());
        this.data[11] = new ST(this.getMessage());
        this.data[12] = new DTM(this.getMessage());
        this.data[13] = new DTM(this.getMessage());
        this.data[14] = new CWE(this.getMessage());
        this.data[15] = new CWE(this.getMessage());
        this.data[16] = new EI(this.getMessage());
        this.data[17] = new NM(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getTelephoneNumber() {
        return (ST)this.getTyped(0, ST.class);
    }

    public ST getXtn1_TelephoneNumber() {
        return (ST)this.getTyped(0, ST.class);
    }

    public ID getTelecommunicationUseCode() {
        return (ID)this.getTyped(1, ID.class);
    }

    public ID getXtn2_TelecommunicationUseCode() {
        return (ID)this.getTyped(1, ID.class);
    }

    public ID getTelecommunicationEquipmentType() {
        return (ID)this.getTyped(2, ID.class);
    }

    public ID getXtn3_TelecommunicationEquipmentType() {
        return (ID)this.getTyped(2, ID.class);
    }

    public ST getCommunicationAddress() {
        return (ST)this.getTyped(3, ST.class);
    }

    public ST getXtn4_CommunicationAddress() {
        return (ST)this.getTyped(3, ST.class);
    }

    public SNM getCountryCode() {
        return (SNM)this.getTyped(4, SNM.class);
    }

    public SNM getXtn5_CountryCode() {
        return (SNM)this.getTyped(4, SNM.class);
    }

    public SNM getAreaCityCode() {
        return (SNM)this.getTyped(5, SNM.class);
    }

    public SNM getXtn6_AreaCityCode() {
        return (SNM)this.getTyped(5, SNM.class);
    }

    public SNM getLocalNumber() {
        return (SNM)this.getTyped(6, SNM.class);
    }

    public SNM getXtn7_LocalNumber() {
        return (SNM)this.getTyped(6, SNM.class);
    }

    public SNM getExtension() {
        return (SNM)this.getTyped(7, SNM.class);
    }

    public SNM getXtn8_Extension() {
        return (SNM)this.getTyped(7, SNM.class);
    }

    public ST getAnyText() {
        return (ST)this.getTyped(8, ST.class);
    }

    public ST getXtn9_AnyText() {
        return (ST)this.getTyped(8, ST.class);
    }

    public ST getExtensionPrefix() {
        return (ST)this.getTyped(9, ST.class);
    }

    public ST getXtn10_ExtensionPrefix() {
        return (ST)this.getTyped(9, ST.class);
    }

    public ST getSpeedDialCode() {
        return (ST)this.getTyped(10, ST.class);
    }

    public ST getXtn11_SpeedDialCode() {
        return (ST)this.getTyped(10, ST.class);
    }

    public ST getUnformattedTelephoneNumber() {
        return (ST)this.getTyped(11, ST.class);
    }

    public ST getXtn12_UnformattedTelephoneNumber() {
        return (ST)this.getTyped(11, ST.class);
    }

    public DTM getEffectiveStartDate() {
        return (DTM)this.getTyped(12, DTM.class);
    }

    public DTM getXtn13_EffectiveStartDate() {
        return (DTM)this.getTyped(12, DTM.class);
    }

    public DTM getExpirationDate() {
        return (DTM)this.getTyped(13, DTM.class);
    }

    public DTM getXtn14_ExpirationDate() {
        return (DTM)this.getTyped(13, DTM.class);
    }

    public CWE getExpirationReason() {
        return (CWE)this.getTyped(14, CWE.class);
    }

    public CWE getXtn15_ExpirationReason() {
        return (CWE)this.getTyped(14, CWE.class);
    }

    public CWE getProtectionCode() {
        return (CWE)this.getTyped(15, CWE.class);
    }

    public CWE getXtn16_ProtectionCode() {
        return (CWE)this.getTyped(15, CWE.class);
    }

    public EI getSharedTelecommunicationIdentifier() {
        return (EI)this.getTyped(16, EI.class);
    }

    public EI getXtn17_SharedTelecommunicationIdentifier() {
        return (EI)this.getTyped(16, EI.class);
    }

    public NM getPreferenceOrder() {
        return (NM)this.getTyped(17, NM.class);
    }

    public NM getXtn18_PreferenceOrder() {
        return (NM)this.getTyped(17, NM.class);
    }
}

