/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v281.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v281.group.EHC_E20_PAT_INFO;
import ca.uhn.hl7v2.model.v281.group.EHC_E20_PSL_ITEM_INFO;
import ca.uhn.hl7v2.model.v281.segment.CTD;
import ca.uhn.hl7v2.model.v281.segment.IVC;
import ca.uhn.hl7v2.model.v281.segment.LOC;
import ca.uhn.hl7v2.model.v281.segment.MSH;
import ca.uhn.hl7v2.model.v281.segment.ROL;
import ca.uhn.hl7v2.model.v281.segment.SFT;
import ca.uhn.hl7v2.model.v281.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EHC_E20
extends AbstractMessage {
    public EHC_E20() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public EHC_E20(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, true);
            this.add(IVC.class, true, false);
            this.add(CTD.class, true, true);
            this.add(LOC.class, false, true);
            this.add(ROL.class, false, true);
            this.add(EHC_E20_PAT_INFO.class, true, true);
            this.add(EHC_E20_PSL_ITEM_INFO.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EHC_E20 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.8.1";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public UAC getUAC(int rep) {
        return (UAC)this.getTyped("UAC", rep, UAC.class);
    }

    public int getUACReps() {
        return this.getReps("UAC");
    }

    public List<UAC> getUACAll() throws HL7Exception {
        return this.getAllAsList("UAC", UAC.class);
    }

    public void insertUAC(UAC structure, int rep) throws HL7Exception {
        super.insertRepetition("UAC", (Structure)structure, rep);
    }

    public UAC insertUAC(int rep) throws HL7Exception {
        return (UAC)super.insertRepetition("UAC", rep);
    }

    public UAC removeUAC(int rep) throws HL7Exception {
        return (UAC)super.removeRepetition("UAC", rep);
    }

    public IVC getIVC() {
        return (IVC)this.getTyped("IVC", IVC.class);
    }

    public CTD getCTD() {
        return (CTD)this.getTyped("CTD", CTD.class);
    }

    public CTD getCTD(int rep) {
        return (CTD)this.getTyped("CTD", rep, CTD.class);
    }

    public int getCTDReps() {
        return this.getReps("CTD");
    }

    public List<CTD> getCTDAll() throws HL7Exception {
        return this.getAllAsList("CTD", CTD.class);
    }

    public void insertCTD(CTD structure, int rep) throws HL7Exception {
        super.insertRepetition("CTD", (Structure)structure, rep);
    }

    public CTD insertCTD(int rep) throws HL7Exception {
        return (CTD)super.insertRepetition("CTD", rep);
    }

    public CTD removeCTD(int rep) throws HL7Exception {
        return (CTD)super.removeRepetition("CTD", rep);
    }

    public LOC getLOC() {
        return (LOC)this.getTyped("LOC", LOC.class);
    }

    public LOC getLOC(int rep) {
        return (LOC)this.getTyped("LOC", rep, LOC.class);
    }

    public int getLOCReps() {
        return this.getReps("LOC");
    }

    public List<LOC> getLOCAll() throws HL7Exception {
        return this.getAllAsList("LOC", LOC.class);
    }

    public void insertLOC(LOC structure, int rep) throws HL7Exception {
        super.insertRepetition("LOC", (Structure)structure, rep);
    }

    public LOC insertLOC(int rep) throws HL7Exception {
        return (LOC)super.insertRepetition("LOC", rep);
    }

    public LOC removeLOC(int rep) throws HL7Exception {
        return (LOC)super.removeRepetition("LOC", rep);
    }

    public ROL getROL() {
        return (ROL)this.getTyped("ROL", ROL.class);
    }

    public ROL getROL(int rep) {
        return (ROL)this.getTyped("ROL", rep, ROL.class);
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", (Structure)structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public EHC_E20_PAT_INFO getPAT_INFO() {
        return (EHC_E20_PAT_INFO)this.getTyped("PAT_INFO", EHC_E20_PAT_INFO.class);
    }

    public EHC_E20_PAT_INFO getPAT_INFO(int rep) {
        return (EHC_E20_PAT_INFO)this.getTyped("PAT_INFO", rep, EHC_E20_PAT_INFO.class);
    }

    public int getPAT_INFOReps() {
        return this.getReps("PAT_INFO");
    }

    public List<EHC_E20_PAT_INFO> getPAT_INFOAll() throws HL7Exception {
        return this.getAllAsList("PAT_INFO", EHC_E20_PAT_INFO.class);
    }

    public void insertPAT_INFO(EHC_E20_PAT_INFO structure, int rep) throws HL7Exception {
        super.insertRepetition("PAT_INFO", (Structure)structure, rep);
    }

    public EHC_E20_PAT_INFO insertPAT_INFO(int rep) throws HL7Exception {
        return (EHC_E20_PAT_INFO)super.insertRepetition("PAT_INFO", rep);
    }

    public EHC_E20_PAT_INFO removePAT_INFO(int rep) throws HL7Exception {
        return (EHC_E20_PAT_INFO)super.removeRepetition("PAT_INFO", rep);
    }

    public EHC_E20_PSL_ITEM_INFO getPSL_ITEM_INFO() {
        return (EHC_E20_PSL_ITEM_INFO)this.getTyped("PSL_ITEM_INFO", EHC_E20_PSL_ITEM_INFO.class);
    }

    public EHC_E20_PSL_ITEM_INFO getPSL_ITEM_INFO(int rep) {
        return (EHC_E20_PSL_ITEM_INFO)this.getTyped("PSL_ITEM_INFO", rep, EHC_E20_PSL_ITEM_INFO.class);
    }

    public int getPSL_ITEM_INFOReps() {
        return this.getReps("PSL_ITEM_INFO");
    }

    public List<EHC_E20_PSL_ITEM_INFO> getPSL_ITEM_INFOAll() throws HL7Exception {
        return this.getAllAsList("PSL_ITEM_INFO", EHC_E20_PSL_ITEM_INFO.class);
    }

    public void insertPSL_ITEM_INFO(EHC_E20_PSL_ITEM_INFO structure, int rep) throws HL7Exception {
        super.insertRepetition("PSL_ITEM_INFO", (Structure)structure, rep);
    }

    public EHC_E20_PSL_ITEM_INFO insertPSL_ITEM_INFO(int rep) throws HL7Exception {
        return (EHC_E20_PSL_ITEM_INFO)super.insertRepetition("PSL_ITEM_INFO", rep);
    }

    public EHC_E20_PSL_ITEM_INFO removePSL_ITEM_INFO(int rep) throws HL7Exception {
        return (EHC_E20_PSL_ITEM_INFO)super.removeRepetition("PSL_ITEM_INFO", rep);
    }
}

